/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.odkl;

import org.apache.spark.ml.odkl.QuantileDiscretizerBase;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntArrayParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public abstract class QuantileDiscretizerBase$class {
    public static int getNumBuckets(QuantileDiscretizerBase $this) {
        return BoxesRunTime.unboxToInt((Object)$this.getOrDefault((Param)$this.numBuckets()));
    }

    public static int[] getNumBucketsArray(QuantileDiscretizerBase $this) {
        return (int[])$this.$((Param)$this.numBucketsArray());
    }

    public static double getRelativeError(QuantileDiscretizerBase $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.getOrDefault((Param)$this.relativeError()));
    }

    public static void $init$(QuantileDiscretizerBase $this) {
        $this.org$apache$spark$ml$odkl$QuantileDiscretizerBase$_setter_$numBuckets_$eq(new IntParam((Identifiable)$this, "numBuckets", "Number of buckets (quantiles, or categories) into which data points are grouped. Must be >= 2.", ParamValidators$.MODULE$.gtEq(2.0)));
        $this.setDefault((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.numBuckets().$minus$greater((Object)BoxesRunTime.boxToInteger((int)2))}));
        $this.org$apache$spark$ml$odkl$QuantileDiscretizerBase$_setter_$numBucketsArray_$eq(new IntArrayParam((Params)$this, "numBucketsArray", "Array of number of buckets (quantiles, or categories) into which data points are grouped. This is for multiple columns input. If transforming multiple columns and numBucketsArray is not set, but numBuckets is set, then numBuckets will be applied across all columns.", (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int[] arrayOfNumBuckets) {
                return Predef$.MODULE$.intArrayOps(arrayOfNumBuckets).forall(ParamValidators$.MODULE$.gtEq(2.0));
            }
        }));
        $this.org$apache$spark$ml$odkl$QuantileDiscretizerBase$_setter_$relativeError_$eq(new DoubleParam((Identifiable)$this, "relativeError", "The relative target precision for the approximate quantile algorithm used to generate buckets. Must be in the range [0, 1].", ParamValidators$.MODULE$.inRange(0.0, 1.0)));
        $this.setDefault((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.relativeError().$minus$greater((Object)BoxesRunTime.boxToDouble((double)0.001))}));
        $this.org$apache$spark$ml$odkl$QuantileDiscretizerBase$_setter_$handleInvalid_$eq(new Param((Identifiable)$this, "handleInvalid", "how to handle invalid entries. Options are skip (filter out rows with invalid values), error (throw an error), or keep (keep invalid values in a special additional bucket).", ParamValidators$.MODULE$.inArray((Object)new String[]{"skip", "error", "keep"})));
        $this.setDefault($this.handleInvalid(), "error");
    }
}

