package k.common

import k.ofl.OFL
import java.io.File

fun env(path : String) =
    OFL().also {
        (File(path).text default "")
            .lines()
            .associate { line -> line.substringBefore('=').trim() to line.substringAfter('=').trim() }
            .forEach { (key, value) -> it.add(key, value) }
    }