package k.common

/**
 * List must be empty
 * Map be not empty
 */
infix fun <T> List<T>.mustBeEmpty(message : String) =
    this.isEmpty() orThrow { CheckError("$message [${this.joinToString()}]") }

@Suppress("NOTHING_TO_INLINE")
inline infix fun <T> Map<String, T>.mustBeEmpty(message : String) =
    this.isEmpty() orThrow { CheckError("$message [${this.keys.joinToString()}]") }