package k.ofl

import k.common.*

class OflProperty() : OflItem()
{
    constructor(name : String, value : String) : this()
    {
        this.name = name
        this.value = value
    }

    override var value = ""

    override val clone
        get() : OflItem = OflProperty().also {
            it.name = name
            it.value = value
        }

    override val json
        get() = super.json + if (parent is OflArray)
            ""
        else
        {
            val valStr = if (value.isEmpty())
                "\"\""
            else if (when (value.first()) {
                in "0123456789" -> value.toDoubleOrNull().isNotNull
                'f' -> value == "false"
                't' -> value == "true"
                else -> false
            })
                value
            else
                """"$value""""

            val maskedValStr = valStr.replace("\n", "\\n")

            ":$maskedValStr"
        }

    override fun fmt(offset : String, alignPos : Int) : String
    {
        val titleStr = title

        return offset + (titleStr merge (' '.pad(alignPos - titleStr.length) + "= ")) + quoteStr(value)
    }

    override val str
        get() = (super.str merge "=") + quoteStr(value)
}