package k.ofl

val OflObject.yaml
    get() = yaml("")

fun OflItem.yaml(offset : String) : String =
    when (this) {
        is OFL       -> items.joinToString("\n") { it.yaml("") }
        is OflArray  ->
            "$offset$title:" + items.joinToString("") { "\n$offset  - ${it.title}" }

        is OflObject -> "$offset$title:\n" + items.joinToString("\n") { it.yaml("$offset  ") }
        else         -> "$offset$title: ${quoteStr(value)}"
    }