package k.serializing.json

import k.common.str

class JsonArray(name : String, items : List<JsonNode>) : JsonContainer(name, items) {
    override fun toString() =
        items.joinToString("$divider ", prefix = openArray.str, postfix = closeArray.str)

    override fun toJson() =
        items.joinToString(divider.str, prefix = openArray.str, postfix = closeArray.str) { it.toJson() }
}