/*
 * Decompiled with CFR 0.152.
 */
package k.common;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import k.common.DurationKt;
import k.common.NumbersKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 C2\u00020\u0001:\u0001CB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB\u0017\b\u0016\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\u0004\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0004\u0010\u000fB\u0019\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0004\u0010\u0012J\u0011\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u000eH\u0086\u0002J\u0011\u0010*\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010*\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.H\u0086\u0002J\u0011\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020/H\u0086\u0002J\u0011\u0010,\u001a\u00020.2\u0006\u0010)\u001a\u00020\u0000H\u0086\u0002J\u0011\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0003H\u0086\u0002J\u0011\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020/H\u0086\u0002J\u0011\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020.H\u0086\u0002J\u0011\u00102\u001a\u00020/2\u0006\u0010)\u001a\u00020\u0000H\u0086\u0002J\u0011\u00102\u001a\u00020/2\u0006\u0010)\u001a\u00020\u0003H\u0086\u0002J\u0011\u00102\u001a\u00020/2\u0006\u0010)\u001a\u00020\u0007H\u0086\u0002J\u0013\u00103\u001a\u00020$2\b\u00104\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0011\u00105\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0086\u0004J\b\u00106\u001a\u00020\u0007H\u0016J\u0006\u0010>\u001a\u00020\u000bJ\b\u0010?\u001a\u00020/H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u0011\u0010\u001b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0014R\u0011\u0010\u001d\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0014R\u0011\u0010\u001f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0014R\u0011\u0010!\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0014R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010%R\u0011\u0010&\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010%R\u0011\u0010'\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010%R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0011\u00109\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b:\u00108R\u0011\u0010)\u001a\u00020;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0011\u0010@\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bA\u0010B\u00a8\u0006D"}, d2={"Lk/common/Duration;", "", "value", "", "<init>", "(J)V", "str", "", "(Ljava/lang/String;)V", "code", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "date", "Ljava/util/Date;", "(Ljava/util/Date;)V", "someTime", "anotherTime", "(Ljava/util/Date;Ljava/util/Date;)V", "getValue", "()J", "us", "getUs", "ms", "getMs", "sec", "getSec", "min", "getMin", "hours", "getHours", "days", "getDays", "months", "getMonths", "isZero", "", "()Z", "isPositive", "isNegative", "minus", "duration", "plus", "time", "div", "divider", "", "", "times", "multiplicator", "compareTo", "equals", "other", "max", "toString", "getStr", "()Ljava/lang/String;", "string", "getString", "Ljava/time/Duration;", "getDuration", "()Ljava/time/Duration;", "sleep", "hashCode", "random", "getRandom", "()Lk/common/Duration;", "Companion", "k-lib-common"})
@SourceDebugExtension(value={"SMAP\nDuration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Duration.kt\nk/common/Duration\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,275:1\n31#2,6:276\n*S KotlinDebug\n*F\n+ 1 Duration.kt\nk/common/Duration\n*L\n26#1:276,6\n*E\n"})
public final class Duration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long value;
    @NotNull
    private static final Duration ZERO = new Duration(0L);
    @NotNull
    private static final Duration INFINITE = new Duration(Long.MAX_VALUE);
    @NotNull
    private static final Duration NEGATIVE_INFINITE = new Duration(Long.MIN_VALUE);
    private static final long ATOM = 1L;

    public Duration(long value) {
        this.value = value;
    }

    public final long getValue() {
        return this.value;
    }

    public Duration(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this(DurationKt.parseDuration(str));
    }

    public Duration(@NotNull Function0<Unit> code) {
        Intrinsics.checkNotNullParameter(code, (String)"code");
        boolean $i$f$measureNanoTime = false;
        long start$iv = System.nanoTime();
        Duration duration = this;
        boolean bl = false;
        code.invoke();
        duration(System.nanoTime() - start$iv);
    }

    public Duration(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this(new Date(), date);
    }

    public Duration(@NotNull Date someTime, @NotNull Date anotherTime) {
        Intrinsics.checkNotNullParameter((Object)someTime, (String)"someTime");
        Intrinsics.checkNotNullParameter((Object)anotherTime, (String)"anotherTime");
        this(TimeUnit.MILLISECONDS.toNanos(Math.abs(someTime.getTime() - anotherTime.getTime())));
    }

    public final long getUs() {
        return this.value / 1000L;
    }

    public final long getMs() {
        return this.value / 1000000L;
    }

    public final long getSec() {
        return this.value / 1000000000L;
    }

    public final long getMin() {
        return this.value / 60000000000L;
    }

    public final long getHours() {
        return this.value / 3600000000000L;
    }

    public final long getDays() {
        return this.value / 86400000000000L;
    }

    public final long getMonths() {
        return this.value / 2592000000000000L;
    }

    public final boolean isZero() {
        return this.value == 0L;
    }

    public final boolean isPositive() {
        return this.value > 0L;
    }

    public final boolean isNegative() {
        return this.value < 0L;
    }

    @NotNull
    public final Duration minus(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return new Duration(this.value - duration.value);
    }

    @NotNull
    public final Date plus(@NotNull Date time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return new Date(this.getMs() + time.getTime());
    }

    @NotNull
    public final Duration plus(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return new Duration(this.value + duration.value);
    }

    @NotNull
    public final Duration plus(long duration) {
        return new Duration(this.value + duration);
    }

    @NotNull
    public final Duration div(long divider) {
        return new Duration(this.value / divider);
    }

    @NotNull
    public final Duration div(double divider) {
        return new Duration((long)((double)this.value / divider));
    }

    @NotNull
    public final Duration div(int divider) {
        return new Duration(this.value / (long)divider);
    }

    public final double div(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return (double)this.value / (double)duration.value;
    }

    @NotNull
    public final Duration times(long multiplicator) {
        return new Duration(this.value * multiplicator);
    }

    @NotNull
    public final Duration times(int multiplicator) {
        return new Duration(this.value * (long)multiplicator);
    }

    @NotNull
    public final Duration times(double multiplicator) {
        return new Duration(NumbersKt.getLong((double)this.value * multiplicator));
    }

    public final int compareTo(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return duration.value == this.value ? 0 : (duration.value > this.value ? -1 : 1);
    }

    public final int compareTo(long duration) {
        return duration == this.value ? 0 : (duration > this.value ? -1 : 1);
    }

    public final int compareTo(@NotNull String duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return this.compareTo(new Duration(duration));
    }

    public boolean equals(@Nullable Object other) {
        Object object = other;
        return object instanceof Long ? Intrinsics.areEqual((Object)other, (Object)this.value) : (object instanceof Integer ? (long)((Number)other).intValue() == this.value : (object instanceof Byte ? (long)((Number)other).byteValue() == this.value : (object instanceof Duration ? ((Duration)other).value == this.value : false)));
    }

    @NotNull
    public final Duration max(@NotNull Duration value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.value > value.value ? this : value;
    }

    @NotNull
    public final Duration min(@NotNull Duration value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.value < value.value ? this : value;
    }

    @NotNull
    public String toString() {
        return this.getStr();
    }

    @NotNull
    public final String getStr() {
        return DurationKt.durationStr(this.value, true);
    }

    @NotNull
    public final String getString() {
        return DurationKt.durationStr(this.value, false);
    }

    @NotNull
    public final java.time.Duration getDuration() {
        java.time.Duration duration = java.time.Duration.ofNanos(this.value);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofNanos(...)");
        return duration;
    }

    public final void sleep() {
        if (this.getMs() >= 1L) {
            Thread.sleep(this.getMs());
        }
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    @NotNull
    public final Duration getRandom() {
        return new Duration(RangesKt.random((LongRange)new LongRange(0L, this.value), (Random)((Random)Random.Default)));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\rX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lk/common/Duration$Companion;", "", "<init>", "()V", "ZERO", "Lk/common/Duration;", "getZERO", "()Lk/common/Duration;", "INFINITE", "getINFINITE", "NEGATIVE_INFINITE", "getNEGATIVE_INFINITE", "ATOM", "", "getATOM", "()J", "k-lib-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getZERO() {
            return ZERO;
        }

        @NotNull
        public final Duration getINFINITE() {
            return INFINITE;
        }

        @NotNull
        public final Duration getNEGATIVE_INFINITE() {
            return NEGATIVE_INFINITE;
        }

        public final long getATOM() {
            return ATOM;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

