/*
 * Decompiled with CFR 0.152.
 */
package k.common;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import k.common.Duration;
import k.common.ProcessRunnerKt;
import k.common.Timer;
import k.stream.InputStreamExtensionsKt;
import kotlin.Metadata;
import kotlin.UninitializedPropertyAccessException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u001d\u001a\u00020\u001a2\b\b\u0002\u0010\u001e\u001a\u00020\u001fR\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00038F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006 "}, d2={"Lk/common/ProcessRunner;", "", "commandLine", "", "environmentVariables", "", "workDir", "<init>", "(Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)V", "process", "Ljava/lang/Process;", "kotlin.jvm.PlatformType", "Ljava/lang/Process;", "handle", "Ljava/lang/ProcessHandle;", "getHandle", "()Ljava/lang/ProcessHandle;", "value", "output", "getOutput", "()Ljava/lang/String;", "exitCode", "", "getExitCode", "()I", "running", "", "getRunning", "()Z", "wait", "timeout", "Lk/common/Duration;", "k-lib-common"})
@SourceDebugExtension(value={"SMAP\nProcessRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessRunner.kt\nk/common/ProcessRunner\n+ 2 WrapProcs.kt\nk/common/WrapProcsKt\n*L\n1#1,116:1\n159#2,11:117\n*S KotlinDebug\n*F\n+ 1 ProcessRunner.kt\nk/common/ProcessRunner\n*L\n30#1:117,11\n*E\n"})
public final class ProcessRunner {
    private final Process process;
    @NotNull
    private String output;

    /*
     * WARNING - void declaration
     */
    public ProcessRunner(@NotNull String commandLine, @NotNull Map<String, String> environmentVariables, @NotNull String workDir) {
        void it;
        ProcessBuilder processBuilder;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter(environmentVariables, (String)"environmentVariables");
        Intrinsics.checkNotNullParameter((Object)workDir, (String)"workDir");
        ProcessBuilder processBuilder2 = processBuilder = new ProcessBuilder(ProcessRunnerKt.getCmdParams(commandLine)).redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.PIPE);
        ProcessRunner processRunner = this;
        boolean bl = false;
        Map<String, String> map = it.environment();
        Intrinsics.checkNotNullExpressionValue(map, (String)"environment(...)");
        map.putAll(environmentVariables);
        if (!StringsKt.isBlank((CharSequence)workDir)) {
            it.directory(new File(workDir));
        }
        processRunner.process = processBuilder.start();
        this.output = "";
    }

    public /* synthetic */ ProcessRunner(String string, Map map, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        this(string, map, string2);
    }

    @NotNull
    public final ProcessHandle getHandle() {
        ProcessHandle processHandle = this.process.toHandle();
        Intrinsics.checkNotNullExpressionValue((Object)processHandle, (String)"toHandle(...)");
        return processHandle;
    }

    @NotNull
    public final String getOutput() {
        boolean $i$f$mute = false;
        try {
            boolean bl = false;
            if (this.process.getInputStream().available() > 0) {
                InputStream inputStream = this.process.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                this.output = this.output + InputStreamExtensionsKt.getText(inputStream);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            Throwable throwable = e$iv;
            if (throwable instanceof OutOfMemoryError) {
                throw e$iv;
            }
            if (throwable instanceof UninitializedPropertyAccessException) {
                throw e$iv;
            }
            Object var3_5 = null;
        }
        return this.output;
    }

    public final int getExitCode() {
        return this.process.exitValue();
    }

    public final boolean getRunning() {
        return this.process.isAlive();
    }

    public final boolean wait(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Timer timer = new Timer();
        if (!Intrinsics.areEqual((Object)timeout, (Object)Duration.Companion.getINFINITE())) {
            ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, () -> ProcessRunner.wait$lambda$4(this, timer, timeout), (int)31, null);
        }
        while (this.getRunning()) {
            this.getOutput();
        }
        return !this.getRunning() && this.getExitCode() == 0;
    }

    public static /* synthetic */ boolean wait$default(ProcessRunner processRunner, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            duration = Duration.Companion.getINFINITE();
        }
        return processRunner.wait(duration);
    }

    private static final Unit wait$lambda$4$lambda$2(ProcessHandle it) {
        it.destroy();
        return Unit.INSTANCE;
    }

    private static final void wait$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit wait$lambda$4(ProcessRunner this$0, Timer $timer, Duration $timeout) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$timer, (String)"$timer");
        Intrinsics.checkNotNullParameter((Object)$timeout, (String)"$timeout");
        while (this$0.getRunning() && $timer.getTime().compareTo($timeout) < 0) {
            Thread.sleep(100L);
        }
        this$0.process.children().forEach(arg_0 -> ProcessRunner.wait$lambda$4$lambda$3(ProcessRunner::wait$lambda$4$lambda$2, arg_0));
        this$0.process.destroy();
        return Unit.INSTANCE;
    }
}

