/*
 * Decompiled with CFR 0.152.
 */
package k.stream;

import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import k.common.CheckError;
import k.stream.StreamStorage;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001fB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lk/stream/FileStorage;", "Lk/stream/StreamStorage;", "path", "", "mode", "Lk/stream/FileStorage$Mode;", "<init>", "(Ljava/lang/String;Lk/stream/FileStorage$Mode;)V", "file", "Ljava/nio/channels/SeekableByteChannel;", "kotlin.jvm.PlatformType", "Ljava/nio/channels/SeekableByteChannel;", "_", "", "size", "getSize", "()J", "setSize", "(J)V", "read", "", "buf", "Ljava/nio/ByteBuffer;", "position", "write", "flush", "close", "connected", "", "getConnected", "()Z", "Mode", "k-lib-common"})
@SourceDebugExtension(value={"SMAP\nFileStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileStorage.kt\nk/stream/FileStorage\n+ 2 OrThrow.kt\nk/common/OrThrowKt\n*L\n1#1,48:1\n8#2,7:49\n8#2,7:56\n*S KotlinDebug\n*F\n+ 1 FileStorage.kt\nk/stream/FileStorage\n*L\n28#1:49,7\n33#1:56,7\n*E\n"})
public final class FileStorage
implements StreamStorage {
    private final SeekableByteChannel file;

    public FileStorage(@NotNull String path, @NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.file = Files.newByteChannel(Paths.get(path, new String[0]), mode.getOptions(), new FileAttribute[0]);
    }

    public /* synthetic */ FileStorage(String string, Mode mode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            mode = Mode.Read;
        }
        this(string, mode);
    }

    @Override
    public long getSize() {
        return this.file.size();
    }

    @Override
    public void setSize(long l) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void read(@NotNull ByteBuffer buf, long position) {
        void $this$orThrow$iv;
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        boolean bl = this.file.position(position).read(buf.position(0)) == buf.limit();
        String error$iv = "Failed to read";
        boolean $i$f$orThrow = false;
        void $this$orThrow$iv$iv = $this$orThrow$iv;
        boolean $i$f$orThrow2 = false;
        if ($this$orThrow$iv$iv == false) {
            boolean bl2 = false;
            throw (Throwable)new CheckError(error$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull ByteBuffer buf, long position) {
        void $this$orThrow$iv;
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        boolean bl = this.file.position(position).write(buf.position(0)) == buf.limit();
        String error$iv = "Failed to write";
        boolean $i$f$orThrow = false;
        void $this$orThrow$iv$iv = $this$orThrow$iv;
        boolean $i$f$orThrow2 = false;
        if ($this$orThrow$iv$iv == false) {
            boolean bl2 = false;
            throw (Throwable)new CheckError(error$iv);
        }
    }

    @Override
    public void flush() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean getConnected() {
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lk/stream/FileStorage$Mode;", "", "options", "", "Ljava/nio/file/OpenOption;", "<init>", "(Ljava/lang/String;ILjava/util/Set;)V", "getOptions", "()Ljava/util/Set;", "New", "Temp", "Read", "Write", "k-lib-common"})
    public static final class Mode
    extends Enum<Mode> {
        @NotNull
        private final Set<OpenOption> options;
        public static final /* enum */ Mode New;
        public static final /* enum */ Mode Temp;
        public static final /* enum */ Mode Read;
        public static final /* enum */ Mode Write;
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Mode(Set<? extends OpenOption> options) {
            this.options = options;
        }

        @NotNull
        public final Set<OpenOption> getOptions() {
            return this.options;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            Object[] objectArray = new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ};
            New = new Mode(SetsKt.setOf((Object[])objectArray));
            objectArray = new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.DELETE_ON_CLOSE, StandardOpenOption.WRITE, StandardOpenOption.READ};
            Temp = new Mode(SetsKt.setOf((Object[])objectArray));
            Read = new Mode(SetsKt.setOf((Object)StandardOpenOption.READ));
            objectArray = new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.READ};
            Write = new Mode(SetsKt.setOf((Object[])objectArray));
            $VALUES = modeArray = new Mode[]{Mode.New, Mode.Temp, Mode.Read, Mode.Write};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

