/*
 * Decompiled with CFR 0.152.
 */
package k.stream;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import k.common.AmountKt;
import k.common.CheckError;
import k.common.ClassesKt;
import k.common.NumbersKt;
import k.common.OtherKt;
import k.common.StringsKt;
import k.stream.MemoryStorage;
import k.stream.StreamStorage;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u000f\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0007J\u0006\u0010\u0015\u001a\u00020\u0000J\u0006\u0010\u0016\u001a\u00020\u0000J\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00012\b\b\u0002\u0010 \u001a\u00020\fJ\u000e\u0010'\u001a\u00020(2\u0006\u0010\r\u001a\u00020)J\u000e\u0010'\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020(J\u0018\u0010,\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020-2\b\b\u0002\u0010\r\u001a\u00020)J\u0018\u0010,\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020(2\b\b\u0002\u0010.\u001a\u00020\u0013J\u0018\u0010/\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020!2\b\b\u0002\u00100\u001a\u000201J\u001f\u00102\u001a\u00020\u00182\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020403\"\u000204\u00a2\u0006\u0002\u00105J\u0010\u00106\u001a\u00020!2\b\b\u0002\u0010\r\u001a\u00020)J\u0006\u00107\u001a\u00020\u0018J\b\u0010'\u001a\u00020)H\u0016J\u0010\u00108\u001a\u00020)2\u0006\u0010\r\u001a\u00020)H\u0002J \u0010'\u001a\u00020)2\u0006\u00109\u001a\u00020-2\u0006\u0010:\u001a\u00020)2\u0006\u0010;\u001a\u00020)H\u0016J\b\u0010<\u001a\u00020-H\u0016J\u0010\u0010=\u001a\u00020\f2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\f2\u0006\u0010A\u001a\u00020\fH\u0016J\b\u0010B\u001a\u00020)H\u0016J\b\u0010C\u001a\u00020\u0013H\u0016J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010D\u001a\u00020)H\u0016J\b\u0010E\u001a\u00020\u0018H\u0016J\b\u0010F\u001a\u00020\u0018H\u0016J\b\u0010G\u001a\u00020!H\u0016J\u0013\u0010H\u001a\u00020\u00132\b\u0010I\u001a\u0004\u0018\u000104H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R$\u0010\u0019\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000f\"\u0004\b\u001b\u0010\u0011R\u000e\u0010\u001c\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000fR$\u0010\"\u001a\u00020!2\u0006\u0010\u000b\u001a\u00020!8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0011\u0010*\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0014R$\u0010J\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bK\u0010\u000f\"\u0004\bL\u0010\u0011R$\u0010M\u001a\u00020)2\u0006\u0010\u000b\u001a\u00020)8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR$\u0010S\u001a\u00020R2\u0006\u0010\u000b\u001a\u00020R8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR$\u0010Y\u001a\u00020X2\u0006\u0010\u000b\u001a\u00020X8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010]R$\u0010^\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b_\u0010\u0014\"\u0004\b`\u0010aR$\u0010b\u001a\u00020-2\u0006\u0010\u000b\u001a\u00020-8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bc\u0010d\"\u0004\be\u0010fR$\u0010g\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00008F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bh\u0010\n\"\u0004\bi\u0010jR$\u0010l\u001a\u00020k2\u0006\u0010\u000b\u001a\u00020k8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bm\u0010n\"\u0004\bo\u0010pR$\u0010r\u001a\u00020q2\u0006\u0010\u000b\u001a\u00020q8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bs\u0010t\"\u0004\bu\u0010vR0\u0010x\u001a\b\u0012\u0004\u0012\u00020k0w2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020k0w8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\by\u0010z\"\u0004\b{\u0010|R0\u0010}\u001a\b\u0012\u0004\u0012\u00020!0w2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020!0w8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b~\u0010z\"\u0004\b\u007f\u0010|R3\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u00020)0w2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020)0w8F@FX\u0086\u000e\u00a2\u0006\u000e\u001a\u0005\b\u0081\u0001\u0010z\"\u0005\b\u0082\u0001\u0010|R3\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u00020\f0w2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0w8F@FX\u0086\u000e\u00a2\u0006\u000e\u001a\u0005\b\u0084\u0001\u0010z\"\u0005\b\u0085\u0001\u0010|\u00a8\u0006\u0086\u0001"}, d2={"Lk/stream/Stream;", "Ljava/io/InputStream;", "storage", "Lk/stream/StreamStorage;", "<init>", "(Lk/stream/StreamStorage;)V", "source", "(Ljava/io/InputStream;)V", "mirror", "getMirror", "()Lk/stream/Stream;", "value", "", "size", "getSize", "()J", "setSize", "(J)V", "isEmpty", "", "()Z", "first", "last", "clear", "", "position", "getPosition", "setPosition", "mark", "remainSize", "getRemainSize", "copyFrom", "copySize", "", "string", "getString", "()Ljava/lang/String;", "setString", "(Ljava/lang/String;)V", "read", "Ljava/nio/ByteBuffer;", "", "eof", "getEof", "write", "", "entireContent", "writeStrBuf", "charset", "Ljava/nio/charset/Charset;", "writeCSV", "", "", "([Ljava/lang/Object;)V", "readStrBuf", "flush", "realLen", "b", "off", "len", "readAllBytes", "transferTo", "out", "Ljava/io/OutputStream;", "skip", "n", "available", "markSupported", "readAheadLimit", "reset", "close", "toString", "equals", "other", "long", "getLong", "setLong", "int", "getInt", "()I", "setInt", "(I)V", "", "short", "getShort", "()S", "setShort", "(S)V", "", "byte", "getByte", "()B", "setByte", "(B)V", "bln", "getBln", "setBln", "(Z)V", "array", "getArray", "()[B", "setArray", "([B)V", "stream", "getStream", "setStream", "(Lk/stream/Stream;)V", "Ljava/util/UUID;", "uuid", "getUuid", "()Ljava/util/UUID;", "setUuid", "(Ljava/util/UUID;)V", "Ljava/util/Date;", "time", "getTime", "()Ljava/util/Date;", "setTime", "(Ljava/util/Date;)V", "", "uuids", "getUuids", "()Ljava/util/List;", "setUuids", "(Ljava/util/List;)V", "strings", "getStrings", "setStrings", "ints", "getInts", "setInts", "longs", "getLongs", "setLongs", "k-lib-common"})
@SourceDebugExtension(value={"SMAP\nStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Stream.kt\nk/stream/Stream\n+ 2 OrThrow.kt\nk/common/OrThrowKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,359:1\n8#2,7:360\n1863#3,2:367\n1863#3,2:369\n1863#3,2:371\n1863#3,2:373\n*S KotlinDebug\n*F\n+ 1 Stream.kt\nk/stream/Stream\n*L\n111#1:360,7\n322#1:367,2\n333#1:369,2\n344#1:371,2\n355#1:373,2\n*E\n"})
public class Stream
extends InputStream {
    @NotNull
    private final StreamStorage storage;
    private long position;
    private long mark;

    public Stream(@NotNull StreamStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.storage = storage;
    }

    public /* synthetic */ Stream(StreamStorage streamStorage, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            streamStorage = new MemoryStorage(0L, 1, null);
        }
        this(streamStorage);
    }

    public Stream(@NotNull InputStream source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this(null, 1, null);
        Stream.copyFrom$default(this, source, 0L, 2, null);
        this.first();
    }

    @NotNull
    public final Stream getMirror() {
        return new Stream(this.storage);
    }

    public final long getSize() {
        return this.storage.getSize();
    }

    public final void setSize(long value) {
        this.storage.setSize(value);
        if (this.position > value) {
            this.setPosition(value);
        }
    }

    public final boolean isEmpty() {
        return this.getSize() == 0L;
    }

    @NotNull
    public final Stream first() {
        Stream stream;
        Stream it = stream = this;
        boolean bl = false;
        this.setPosition(0L);
        return stream;
    }

    @NotNull
    public final Stream last() {
        Stream stream;
        Stream it = stream = this;
        boolean bl = false;
        this.setPosition(this.getSize());
        return stream;
    }

    public final void clear() {
        this.setSize(0L);
    }

    public final long getPosition() {
        return this.position;
    }

    public final void setPosition(long value) {
        if (value > this.getSize()) {
            this.setSize(value);
        }
        this.position = value;
    }

    public final long getRemainSize() {
        return this.getSize() - this.position;
    }

    public final void copyFrom(@NotNull InputStream source, long copySize) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        long transferSize = copySize < 0L ? NumbersKt.getLong(source.available()) : copySize;
        long needSize = transferSize + this.position;
        if (needSize > this.getSize()) {
            this.setSize(needSize);
        }
        ByteBuffer buf = ByteBuffer.allocate(Integer.min(1024, NumbersKt.getInt(transferSize)));
        while (transferSize > 0L) {
            buf.limit(NumbersKt.getInt(Long.min(NumbersKt.getLong(buf.capacity()), transferSize)));
            source.read(buf.array());
            Intrinsics.checkNotNull((Object)buf);
            Stream.write$default(this, buf, false, 2, null);
            transferSize -= (long)buf.limit();
        }
    }

    public static /* synthetic */ void copyFrom$default(Stream stream, InputStream inputStream, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyFrom");
        }
        if ((n & 2) != 0) {
            l = -1L;
        }
        stream.copyFrom(inputStream, l);
    }

    @NotNull
    public final String getString() {
        byte[] byArray = this.read(this.getInt()).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.UTF_8;
        return new String(byArray2, charset);
    }

    public final void setString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        ByteBuffer buf = ByteBuffer.wrap(byArray);
        this.setInt(buf.limit());
        Intrinsics.checkNotNull((Object)buf);
        Stream.write$default(this, buf, false, 2, null);
    }

    @NotNull
    public final ByteBuffer read(int size) {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(size);
        if (byteBuffer2 == null) {
            throw new OutOfMemoryError();
        }
        ByteBuffer buf = byteBuffer = byteBuffer2;
        boolean bl = false;
        this.read(buf);
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    public final void read(@NotNull ByteBuffer value) {
        void $this$orThrow$iv;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value.limit() == 0) {
            return;
        }
        boolean bl = (long)value.limit() <= this.getRemainSize();
        String error$iv = "Not enough data";
        boolean $i$f$orThrow = false;
        void $this$orThrow$iv$iv = $this$orThrow$iv;
        boolean $i$f$orThrow2 = false;
        if ($this$orThrow$iv$iv == false) {
            boolean bl2 = false;
            throw (Throwable)new CheckError(error$iv);
        }
        ByteBuffer byteBuffer = value.position(0);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"position(...)");
        this.storage.read(byteBuffer, this.position);
        this.setPosition(this.position + (long)value.limit());
    }

    public final boolean getEof() {
        return this.getSize() <= this.position;
    }

    public final void write(@NotNull byte[] value, int size) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ByteBuffer byteBuffer = ByteBuffer.wrap(value).limit(NumbersKt.default(size, value.length));
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"limit(...)");
        Stream.write$default(this, byteBuffer, false, 2, null);
    }

    public static /* synthetic */ void write$default(Stream stream, byte[] byArray, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
        }
        if ((n2 & 2) != 0) {
            n = -1;
        }
        stream.write(byArray, n);
    }

    public final void write(@NotNull ByteBuffer value, boolean entireContent) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value.limit() == 0) {
            return;
        }
        int offset = ((Number)OtherKt.choose(entireContent, 0, value.position())).intValue();
        long newSize = this.position + (long)value.limit() - (long)offset;
        if (newSize > this.getSize()) {
            this.setSize(newSize);
        }
        ByteBuffer byteBuffer = value.position(offset);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"position(...)");
        this.storage.write(byteBuffer, this.position);
        this.setPosition(newSize);
    }

    public static /* synthetic */ void write$default(Stream stream, ByteBuffer byteBuffer, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        stream.write(byteBuffer, bl);
    }

    public final void writeStrBuf(@NotNull String value, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        byte[] byArray = value.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        Stream.write$default(this, byteBuffer, false, 2, null);
    }

    public static /* synthetic */ void writeStrBuf$default(Stream stream, String string, Charset charset, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeStrBuf");
        }
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        stream.writeStrBuf(string, charset);
    }

    public final void writeCSV(Object ... value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Stream.writeStrBuf$default(this, StringsKt.getN(ArraysKt.joinToString$default((Object[])value, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)), null, 2, null);
    }

    @NotNull
    public final String readStrBuf(int size) {
        byte[] byArray = this.read(size).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.UTF_8;
        return new String(byArray2, charset);
    }

    public static /* synthetic */ String readStrBuf$default(Stream stream, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readStrBuf");
        }
        if ((n2 & 1) != 0) {
            n = NumbersKt.getInt(stream.getSize());
        }
        return stream.readStrBuf(n);
    }

    public final void flush() {
        this.storage.flush();
    }

    @Override
    public int read() {
        return this.getRemainSize() > 0L ? (int)this.getByte() : -1;
    }

    private final int realLen(int size) {
        return Integer.min(size, (int)this.getRemainSize());
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int realLen = this.realLen(len - off);
        if (realLen == 0) {
            return -1;
        }
        System.arraycopy(this.read(realLen).array(), 0, b, off, realLen);
        return realLen;
    }

    @Override
    @NotNull
    public byte[] readAllBytes() {
        byte[] byArray;
        byte[] it = byArray = new byte[(int)this.getSize()];
        boolean bl = false;
        this.read(it, 0, it.length);
        return byArray;
    }

    @Override
    public long transferTo(@NotNull OutputStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    public long skip(long n) {
        this.setPosition(this.position + n);
        return n;
    }

    @Override
    public int available() {
        return (int)this.getRemainSize();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.position;
    }

    @Override
    public void reset() {
        this.setPosition(this.mark);
    }

    @Override
    public void close() {
        this.storage.close();
    }

    @NotNull
    public String toString() {
        return ClassesKt.getClassName(this.storage) + StringsKt.accept((Boolean)(this.storage.getSize() < Long.MAX_VALUE ? 1 : 0), ": " + AmountKt.getSizeStr(this.position) + " of " + AmountKt.getSizeStr(this.getSize()));
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Stream) || this.getSize() != ((Stream)other).getSize()) {
            return false;
        }
        ByteBuffer aBuf = ByteBuffer.allocate(1024);
        ByteBuffer bBuf = ByteBuffer.allocate(1024);
        this.first();
        ((Stream)other).first();
        while (this.getRemainSize() > 0L) {
            Intrinsics.checkNotNull((Object)aBuf);
            this.read(aBuf);
            Stream stream = (Stream)other;
            Intrinsics.checkNotNull((Object)bBuf);
            stream.read(bBuf);
            if (Intrinsics.areEqual((Object)aBuf, (Object)bBuf)) continue;
            return false;
        }
        return true;
    }

    public final long getLong() {
        return this.read(8).getLong();
    }

    public final void setLong(long value) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(value);
        Intrinsics.checkNotNull((Object)buf);
        Stream.write$default(this, buf, false, 2, null);
    }

    public final int getInt() {
        return this.read(4).getInt();
    }

    public final void setInt(int value) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(value);
        Intrinsics.checkNotNull((Object)buf);
        Stream.write$default(this, buf, false, 2, null);
    }

    public final short getShort() {
        return this.read(2).getShort();
    }

    public final void setShort(short value) {
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.putShort(value);
        Intrinsics.checkNotNull((Object)buf);
        Stream.write$default(this, buf, false, 2, null);
    }

    public final byte getByte() {
        return this.read(1).get(0);
    }

    public final void setByte(byte value) {
        ByteBuffer buf = ByteBuffer.allocate(1);
        buf.put(value);
        Intrinsics.checkNotNull((Object)buf);
        Stream.write$default(this, buf, false, 2, null);
    }

    public final boolean getBln() {
        return NumbersKt.getBln(this.getByte());
    }

    public final void setBln(boolean value) {
        this.setByte(NumbersKt.getByte(value));
    }

    @NotNull
    public final byte[] getArray() {
        byte[] byArray = this.read(this.getInt()).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        return byArray;
    }

    public final void setArray(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setInt(value.length);
        ByteBuffer byteBuffer = ByteBuffer.wrap(value);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        Stream.write$default(this, byteBuffer, false, 2, null);
    }

    @NotNull
    public final Stream getStream() {
        Stream stream;
        Stream it = stream = new Stream(null, 1, null);
        boolean bl = false;
        it.copyFrom(this, this.getLong());
        it.first();
        return stream;
    }

    public final void setStream(@NotNull Stream value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setLong(value.getSize());
        Stream.copyFrom$default(this, value, 0L, 2, null);
    }

    @NotNull
    public final UUID getUuid() {
        return new UUID(this.getLong(), this.getLong());
    }

    public final void setUuid(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setLong(value.getMostSignificantBits());
        this.setLong(value.getLeastSignificantBits());
    }

    @NotNull
    public final Date getTime() {
        return new Date(this.getLong());
    }

    public final void setTime(@NotNull Date value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setLong(value.getTime());
    }

    @NotNull
    public final List<UUID> getUuids() {
        return NumbersKt.map(this.getInt(), arg_0 -> Stream._get_uuids_$lambda$5(this, arg_0));
    }

    public final void setUuids(@NotNull List<UUID> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.setInt(value.size());
        Iterable $this$forEach$iv = value;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID it = (UUID)element$iv;
            boolean bl = false;
            this.setUuid(it);
        }
    }

    @NotNull
    public final List<String> getStrings() {
        return NumbersKt.map(this.getInt(), arg_0 -> Stream._get_strings_$lambda$7(this, arg_0));
    }

    public final void setStrings(@NotNull List<String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.setInt(value.size());
        Iterable $this$forEach$iv = value;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.setString(it);
        }
    }

    @NotNull
    public final List<Integer> getInts() {
        return NumbersKt.map(this.getInt(), arg_0 -> Stream._get_ints_$lambda$9(this, arg_0));
    }

    public final void setInts(@NotNull List<Integer> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.setInt(value.size());
        Iterable $this$forEach$iv = value;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            this.setInt(it);
        }
    }

    @NotNull
    public final List<Long> getLongs() {
        return NumbersKt.map(this.getInt(), arg_0 -> Stream._get_longs_$lambda$11(this, arg_0));
    }

    public final void setLongs(@NotNull List<Long> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.setInt(value.size());
        Iterable $this$forEach$iv = value;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            this.setLong(it);
        }
    }

    private static final UUID _get_uuids_$lambda$5(Stream this$0, int it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getUuid();
    }

    private static final String _get_strings_$lambda$7(Stream this$0, int it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getString();
    }

    private static final int _get_ints_$lambda$9(Stream this$0, int it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getInt();
    }

    private static final long _get_longs_$lambda$11(Stream this$0, int it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getLong();
    }

    public Stream() {
        this(null, 1, null);
    }
}

