package k.common

import java.text.SimpleDateFormat
import java.util.*

const val TimeFormat = "HH:mm:ss"
const val FileDateFormat = "yyyy.MM.dd"
const val FileDateTimeFormat = "$FileDateFormat $TimeFormat"

operator fun Date.minus(value : Date) : Long =
    time - value.time

operator fun Date.minus(duration : Duration) =
    Date(time - duration.ms)

val strTime : String
    get() = SimpleDateFormat(TimeFormat).format(Date())

val fileNow : String
    get() = SimpleDateFormat(FileDateTimeFormat).format(Date())

val Date.asSQL : java.sql.Timestamp
    get() = java.sql.Timestamp(this.time)

val Date.asDateStr
    get() = SimpleDateFormat(FileDateFormat).format(this)

val Date.asDateTimeStr
    get() = SimpleDateFormat(FileDateTimeFormat).format(this)