package k.common

open class Error(message : String) : Exception(message)

class CheckError(message : String) : Error(message)

class NotFoundError(message : String) : Error(message)

class NotSpecifiedError(id : String) : Error(""""$id" not specified""")

inline fun <T> replaceError(message : String, block : () -> T) =
    try {
        block()
    }
    catch (e : Throwable) {
        throw Exception("$message\n$e")
    }

fun <T> showBadItem(item : String, block : () -> T) =
    try {
        block()
    }
    catch (e : Throwable) {
        msg(item.n, MsgType.Error)
        throw e
    }

fun collectErrors(vararg code : () -> Unit) =
    code.mapNotNull {
        try {
            it()
            null
        }
        catch (e : Throwable) {
            e.str
        }
    }

val Throwable.fmtStackTrace : String
    get() {
        return stackTraceToString() - "at "
        /*
                val modules = stackTrace.map {
                    (it.fileName?.substringBeforeLast(".") ?: "?") to "${it.methodName} (${it.lineNumber})"
                }

                val maxModuleName = modules.maxOf { it.first.length }

                return modules
                    .joinToString("\n") {
                        "${it.first + ' '.pad(maxModuleName - it.first.length)} : ${it.second})"
                    }*/
    }