package k.common

val Any?.str : String
    get() = try
    {
        when (this)
        {
            is Exception -> message
                            ?: javaClass.name

            is Double    -> "%.${1}f".format(this)
            is CharArray -> concatToString()
            is String    -> this
            is List<*>   -> "[" + joinToString(",") { "\"$it\"" } + "]"
            else         -> this?.toString()
                            ?: ""
        }
    }
    catch (e : Throwable)
    {
        e.message
        ?: e.javaClass.name
    }