package k.common

class Timer
{
    private var start = nanoSeconds()

    fun stop() : Timer
    {
        duration = time

        return this
    }

    var duration = Duration.ZERO
        private set

    val time
        get() = Duration(nanoSeconds() - start)

    private fun nanoSeconds() =
        System.nanoTime()

    fun reset() =
        time.also {
            start = nanoSeconds()
        }

    fun checkTimeOut(timeOut : Duration, message : String = "Timeout exceeded $time of $timeOut") =
        (time <= timeOut) orThrow message

    fun checkTimeOut(timeOut : Duration, code : () -> Unit)
    {
        if (time > timeOut)
        {
            code()
            reset()
        }
    }
}