package k.ofl

import k.common.*
import k.ofl.parse.commentChar

open class OflItem {
    var name = ""

    open val key
        get() = name

    val fullName : String
        get() = parent?.fullName?.dot.str + name

    val path : String
        get() = parent?.path?.let { it.dot + name }
            ?: ""

    var parent : OflObject? = null
        internal set

    open var value
        get() = name
        set(value) {
            name = value
        }

    open val values
        get() = arrayOf(value)

    val title
        get() = quoteStr(name)

    open val clone
        get() : OflItem = OflItem().also { it.name = name }

    override fun toString() =
        name

    /**
     * JSON representation of objects subtree
     */
    open val json
        get() = """"$name""""

    /**
     * Formatted text representation of objects subtree
     */
    val fmt
        get() = fmt("", title.length + 1)

    open fun fmt(offset : String = "", alignPos : Int = 0) =
        "$offset$title"

    /**
     * Minified text representation of  objects subtree
     */
    open val str
        get() = title

    internal fun quoteStr(str : String) =
        when {
            ('"' in str) && ("'" in str)          -> "`$str`"
            ('"' in str) && ("'" !in str)         -> "'$str'"
            str hasOneOf "\$ $commentChar{}[]()=" -> """"$str""""
            else                                  -> str
        }

    /**
     * Level of current item.
     */
    open val level : Int
        get() = 1 + (parent?.level
            ?: 0)
}