package k.serializing

import k.ofl.*

inline fun <reified T : Any> OflObject.deSerialize(path : String = "") : T =
    object : DeSerializer<OflObject>(childFmt("")) {
        override fun getObj(obj : OflObject, name : String) =
            obj.find(name) as? OflObject

        override fun getValue(obj : OflObject, path : String) =
            obj.getOrNull(path)?.value

        override fun getValue(item : Any) =
            when (item) {
                is OflProperty -> item.value
                is OflItem     -> item.name
                else           -> error("Unexpected item type ${item.javaClass}")
            }

        override fun getMap(obj : OflObject, path : String) =
            (obj.find(path) as? OflObject)
                ?.items
                ?.associateBy { it.key }
    }.deSerialize(this, path)

inline operator fun <reified T : Any> OflObject.plusAssign(value : T) {
    OflSerializer().serialize(this, value, true, null)
}

class OflSerializer : Serializer<OflObject>(), NamedItems {
    override fun getObj(root : OflObject, path : String) =
        root.forceObj(path)

    override fun getList(root : OflObject, path : String) =
        root.forceArr(path)

    override fun setValue(obj : OflObject, name : String, value : String) {
        obj.add(name, value)
    }

    override fun isNativeValue(value : Any) =
        value is OflObject && value.items.isNotEmpty()

    override fun setNativeValue(name : String, obj : OflObject, value : Any) : Unit {
        val item = (value as OflObject).clone
        item.name = name

        obj.add(item)
    }
}