/*
 * Decompiled with CFR 0.152.
 */
package k.console.table;

import java.security.InvalidParameterException;
import java.text.SimpleDateFormat;
import java.util.Date;
import k.common.AmountKt;
import k.common.AnsiColor;
import k.common.Duration;
import k.common.MessagesKt;
import k.common.NumbersKt;
import k.common.OtherKt;
import k.common.StrKt;
import k.common.StringsKt;
import k.console.table.Align;
import k.console.table.CellFormat;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001Bp\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012K\u0010\u0006\u001aG\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0006\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\u0007\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J!\u0010!\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0086\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016RS\u0010\u0006\u001aG\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0006\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b \u00a8\u0006\""}, d2={"Lk/console/table/ColumnType;", "", "align", "Lk/console/table/Align;", "minWidth", "", "fmt", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "value", "Lk/console/table/CellFormat;", "width", "", "noWrap", "", "<init>", "(Ljava/lang/String;ILk/console/table/Align;ILkotlin/jvm/functions/Function3;Z)V", "getAlign", "()Lk/console/table/Align;", "getMinWidth", "()I", "getNoWrap", "()Z", "Text", "ID", "Date", "Progress", "DurationStr", "Percent", "Count", "Number", "invoke", "k-lib-common"})
@SourceDebugExtension(value={"SMAP\nColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnType.kt\nk/console/table/ColumnType\n+ 2 Strings.kt\nk/common/StringsKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,71:1\n54#2,7:72\n108#3:79\n80#3,22:80\n*S KotlinDebug\n*F\n+ 1 ColumnType.kt\nk/console/table/ColumnType\n*L\n62#1:72,7\n62#1:79\n62#1:80,22\n*E\n"})
public final class ColumnType
extends Enum<ColumnType> {
    @NotNull
    private final Align align;
    private final int minWidth;
    @NotNull
    private final Function3<Object, CellFormat, Integer, String> fmt;
    private final boolean noWrap;
    public static final /* enum */ ColumnType Text = new ColumnType("Text", 0, Align.Left, 3, ColumnType::_init_$lambda$0, false, 8, null);
    public static final /* enum */ ColumnType ID = new ColumnType("ID", 1, Align.Left, 3, ColumnType::_init_$lambda$1, false, 8, null);
    public static final /* enum */ ColumnType Date = new ColumnType("Date", 2, Align.Center, 19, ColumnType::_init_$lambda$2, false, 8, null);
    public static final /* enum */ ColumnType Progress = new ColumnType(Align.Left, 10, (Function3<Object, ? super CellFormat, ? super Integer, String>)((Function3)ColumnType::_init_$lambda$3), true);
    public static final /* enum */ ColumnType DurationStr = new ColumnType("DurationStr", 4, Align.Right, 6, ColumnType::_init_$lambda$4, false, 8, null);
    public static final /* enum */ ColumnType Percent = new ColumnType("Percent", 5, Align.Right, 6, ColumnType::_init_$lambda$5, false, 8, null);
    public static final /* enum */ ColumnType Count = new ColumnType("Count", 6, Align.Right, 5, ColumnType::_init_$lambda$6, false, 8, null);
    public static final /* enum */ ColumnType Number = new ColumnType("Number", 7, Align.Right, 5, ColumnType::_init_$lambda$7, false, 8, null);
    private static final /* synthetic */ ColumnType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private ColumnType(Align align, int minWidth, Function3<Object, ? super CellFormat, ? super Integer, String> fmt, boolean noWrap) {
        this.align = align;
        this.minWidth = minWidth;
        this.fmt = fmt;
        this.noWrap = noWrap;
    }

    /* synthetic */ ColumnType(String string, int n, Align align, int n2, Function3 function3, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            bl = false;
        }
        this(align, n2, (Function3<Object, ? super CellFormat, ? super Integer, String>)function3, bl);
    }

    @NotNull
    public final Align getAlign() {
        return this.align;
    }

    public final int getMinWidth() {
        return this.minWidth;
    }

    public final boolean getNoWrap() {
        return this.noWrap;
    }

    @NotNull
    public final String invoke(@NotNull Object value, @NotNull CellFormat fmt, int width) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)fmt, (String)"fmt");
        return (String)this.fmt.invoke(value, (Object)fmt, (Object)width);
    }

    public static ColumnType[] values() {
        return (ColumnType[])$VALUES.clone();
    }

    public static ColumnType valueOf(String value) {
        return Enum.valueOf(ColumnType.class, value);
    }

    @NotNull
    public static EnumEntries<ColumnType> getEntries() {
        return $ENTRIES;
    }

    private static final String _init_$lambda$0(Object v, CellFormat cellFormat, int n) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)cellFormat, (String)"<unused var>");
        return StrKt.getStr(v);
    }

    private static final String _init_$lambda$1(Object v, CellFormat cellFormat, int n) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)cellFormat, (String)"<unused var>");
        return StrKt.getStr(v);
    }

    private static final String _init_$lambda$2(Object v, CellFormat cellFormat, int n) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)cellFormat, (String)"<unused var>");
        Object object = v;
        if (object instanceof Long) {
            date = new Date(((Number)v).longValue());
        } else if (object instanceof Date) {
            date = (Date)v;
        } else {
            throw new InvalidParameterException();
        }
        Date date2 = date;
        String string = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(date2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private static final String _init_$lambda$3(Object v, CellFormat f, int w) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        Object object2 = v;
        if (object2 instanceof String) {
            object = (String)v;
        } else if (object2 instanceof Double) {
            f.setAccent(AnsiColor.Undefined);
            f.setTextColor(AnsiColor.Blue);
            f.setColor(AnsiColor.White);
            int value = NumbersKt.getInt(((Number)v).doubleValue() * (double)w);
            object = MessagesKt.conFormat$default(StringsKt.pad(' ', value), null, AnsiColor.Blue, 1, null) + MessagesKt.conFormat$default(StringsKt.pad(' ', w - value), null, AnsiColor.White, 1, null);
        } else {
            throw new InvalidParameterException();
        }
        return object;
    }

    private static final String _init_$lambda$4(Object v, CellFormat cellFormat, int n) {
        Duration duration;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)cellFormat, (String)"<unused var>");
        Object object = v;
        if (object instanceof Duration) {
            duration = (Duration)v;
        } else if (object instanceof Long) {
            duration = new Duration(((Number)v).longValue());
        } else if (object instanceof String) {
            duration = new Duration((String)v);
        } else {
            throw new InvalidParameterException();
        }
        Duration duration2 = duration;
        return OtherKt.choose(NumbersKt.getNegative(duration2.getValue()), "~", duration2.getStr());
    }

    private static final String _init_$lambda$5(Object v, CellFormat cellFormat, int n) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)cellFormat, (String)"<unused var>");
        return StringsKt.getPercentStr((Double)v);
    }

    private static final String _init_$lambda$6(Object v, CellFormat cellFormat, int n) {
        String string;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)cellFormat, (String)"<unused var>");
        Object object = v;
        if (object instanceof Long) {
            string = NumbersKt.getAmount(((Number)v).longValue());
        } else if (object instanceof Integer) {
            string = AmountKt.getAmount(((Number)v).intValue());
        } else if (object instanceof String) {
            String $this$long$iv = (String)v;
            boolean $i$f$getLong = false;
            String $this$dbl$iv$iv = $this$long$iv;
            boolean $i$f$getDbl = false;
            String $this$trim$iv$iv$iv = $this$dbl$iv$iv;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv$iv$iv = $this$trim$iv$iv$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv$iv$iv = 0;
            int endIndex$iv$iv$iv$iv = $this$trim$iv$iv$iv$iv.length() - 1;
            boolean startFound$iv$iv$iv$iv = false;
            while (startIndex$iv$iv$iv$iv <= endIndex$iv$iv$iv$iv) {
                boolean match$iv$iv$iv$iv;
                int index$iv$iv$iv$iv = !startFound$iv$iv$iv$iv ? startIndex$iv$iv$iv$iv : endIndex$iv$iv$iv$iv;
                char it$iv$iv = $this$trim$iv$iv$iv$iv.charAt(index$iv$iv$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv$iv$iv = !kotlin.text.StringsKt.contains$default((CharSequence)"-0123456789.", (char)it$iv$iv, (boolean)false, (int)2, null);
                if (!startFound$iv$iv$iv$iv) {
                    if (!match$iv$iv$iv$iv) {
                        startFound$iv$iv$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv$iv$iv;
                    continue;
                }
                if (!match$iv$iv$iv$iv) break;
                --endIndex$iv$iv$iv$iv;
            }
            string = NumbersKt.getAmount(NumbersKt.getLong(Double.parseDouble(kotlin.text.StringsKt.replace$default((String)((Object)$this$trim$iv$iv$iv$iv.subSequence(startIndex$iv$iv$iv$iv, endIndex$iv$iv$iv$iv + 1)).toString(), (char)',', (char)'.', (boolean)false, (int)4, null))));
        } else {
            throw new InvalidParameterException();
        }
        return string;
    }

    private static final String _init_$lambda$7(Object v, CellFormat cellFormat, int n) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)cellFormat, (String)"<unused var>");
        return StrKt.getStr(v);
    }

    static {
        $VALUES = columnTypeArray = new ColumnType[]{ColumnType.Text, ColumnType.ID, ColumnType.Date, ColumnType.Progress, ColumnType.DurationStr, ColumnType.Percent, ColumnType.Count, ColumnType.Number};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }
}

