/*
 * Decompiled with CFR 0.152.
 */
package k.common;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import k.common.Duration;
import k.common.LogItem;
import k.common.Timer;
import k.parallels.Sleepy;
import kotlin.Metadata;
import kotlin.UninitializedPropertyAccessException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\u000b2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u000bJ\u0006\u0010 \u001a\u00020\u000bR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001a\u00a8\u0006!"}, d2={"Lk/common/BackgroundTask;", "", "desc", "", "parentLog", "Lk/common/LogItem;", "period", "Lk/common/Duration;", "debounce", "code", "Lkotlin/Function1;", "", "<init>", "(Ljava/lang/String;Lk/common/LogItem;Lk/common/Duration;Lk/common/Duration;Lkotlin/jvm/functions/Function1;)V", "log", "getLog", "()Lk/common/LogItem;", "generation", "Ljava/util/concurrent/atomic/AtomicInteger;", "active", "Ljava/util/concurrent/atomic/AtomicBoolean;", "sleepy", "Lk/parallels/Sleepy;", "thread", "Ljava/lang/Thread;", "kotlin.jvm.PlatformType", "Ljava/lang/Thread;", "deBounce", "activate", "wait", "", "waitFor", "stop", "k-lib-common"})
@SourceDebugExtension(value={"SMAP\nBackgroundTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundTask.kt\nk/common/BackgroundTask\n+ 2 WrapProcs.kt\nk/common/WrapProcsKt\n*L\n1#1,59:1\n159#2,11:60\n*S KotlinDebug\n*F\n+ 1 BackgroundTask.kt\nk/common/BackgroundTask\n*L\n24#1:60,11\n*E\n"})
public final class BackgroundTask {
    @NotNull
    private final LogItem log;
    @NotNull
    private final AtomicInteger generation;
    @NotNull
    private final AtomicBoolean active;
    @NotNull
    private final Sleepy sleepy;
    private final Thread thread;

    public BackgroundTask(@NotNull String desc, @NotNull LogItem parentLog, @NotNull Duration period, @NotNull Duration debounce, @NotNull Function1<? super LogItem, Unit> code) {
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        Intrinsics.checkNotNullParameter((Object)parentLog, (String)"parentLog");
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        Intrinsics.checkNotNullParameter((Object)debounce, (String)"debounce");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        this.log = LogItem.post$default(parentLog, "Root of " + desc, null, null, 6, null);
        this.generation = new AtomicInteger(0);
        this.active = new AtomicBoolean(true);
        this.sleepy = new Sleepy();
        this.thread = Thread.startVirtualThread(() -> BackgroundTask.thread$lambda$2(this, desc, code, debounce, period));
    }

    @NotNull
    public final LogItem getLog() {
        return this.log;
    }

    private final void deBounce(Duration period) {
        int startGeneration;
        do {
            startGeneration = this.generation.get();
            period.sleep();
        } while (this.active.get() && startGeneration != this.generation.get());
    }

    public final void activate(boolean wait) {
        this.generation.incrementAndGet();
        if (wait) {
            this.waitFor();
        }
    }

    public static /* synthetic */ void activate$default(BackgroundTask backgroundTask, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        backgroundTask.activate(bl);
    }

    public final void waitFor() {
        this.sleepy.waitFor();
    }

    public final void stop() {
        this.active.set(false);
        this.thread.interrupt();
        this.thread.join();
    }

    private static final Unit thread$lambda$2$lambda$0(Function1 $code, LogItem it) {
        Intrinsics.checkNotNullParameter((Object)$code, (String)"$code");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $code.invoke((Object)it);
        return Unit.INSTANCE;
    }

    private static final void thread$lambda$2(BackgroundTask this$0, String $desc, Function1 $code, Duration $debounce, Duration $period) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$desc, (String)"$desc");
        Intrinsics.checkNotNullParameter((Object)$code, (String)"$code");
        Intrinsics.checkNotNullParameter((Object)$debounce, (String)"$debounce");
        Intrinsics.checkNotNullParameter((Object)$period, (String)"$period");
        while (this$0.active.get()) {
            Unit unit;
            int startGeneration = this$0.generation.get();
            LogItem.rootStage$default(this$0.log, $desc, null, arg_0 -> BackgroundTask.thread$lambda$2$lambda$0($code, arg_0), 2, null);
            boolean $i$f$mute = false;
            try {
                boolean bl = false;
                this$0.sleepy.wakeUp();
                Timer timer = new Timer();
                do {
                    this$0.deBounce($debounce);
                    if (!this$0.active.get() || startGeneration != this$0.generation.get()) break;
                } while (timer.getTime().compareTo($period) < 0);
                unit = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                Throwable throwable = e$iv;
                if (throwable instanceof OutOfMemoryError) {
                    throw e$iv;
                }
                if (throwable instanceof UninitializedPropertyAccessException) {
                    throw e$iv;
                }
                unit = null;
            }
        }
    }
}

