/*
 * Decompiled with CFR 0.152.
 */
package k.common;

import java.util.concurrent.atomic.AtomicLong;
import k.common.Duration;
import k.common.Timer;
import k.parallels.Sync;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0019\u001a\u00020\u001a2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0006J\u0006\u0010\u001d\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0011\u0010\u0012\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lk/common/Cache;", "T", "", "timeout", "Lk/common/Duration;", "builder", "Lkotlin/Function0;", "<init>", "(Lk/common/Duration;Lkotlin/jvm/functions/Function0;)V", "timer", "Lk/common/Timer;", "generation", "Ljava/util/concurrent/atomic/AtomicLong;", "committed", "sync", "Lk/parallels/Sync;", "cachedValue", "Ljava/lang/Object;", "value", "getValue", "()Ljava/lang/Object;", "actual", "", "getActual", "()Z", "invalidate", "", "code", "", "waitForActual", "waitForGeneration", "k-lib-common"})
@SourceDebugExtension(value={"SMAP\nCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cache.kt\nk/common/Cache\n+ 2 Sync.kt\nk/parallels/Sync\n*L\n1#1,52:1\n63#2,7:53\n63#2,7:60\n*S KotlinDebug\n*F\n+ 1 Cache.kt\nk/common/Cache\n*L\n18#1:53,7\n36#1:60,7\n*E\n"})
public final class Cache<T> {
    @NotNull
    private final Duration timeout;
    @NotNull
    private final Function0<T> builder;
    @NotNull
    private final Timer timer;
    @NotNull
    private final AtomicLong generation;
    @NotNull
    private final AtomicLong committed;
    @NotNull
    private final Sync sync;
    private T cachedValue;

    public Cache(@NotNull Duration timeout, @NotNull Function0<? extends T> builder) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.timeout = timeout;
        this.builder = builder;
        this.timer = new Timer();
        this.generation = new AtomicLong(0L);
        this.committed = new AtomicLong(-1L);
        this.sync = new Sync(false, 1, null);
    }

    public /* synthetic */ Cache(Duration duration, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            duration = Duration.Companion.getINFINITE();
        }
        this(duration, function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final T getValue() {
        Sync this_$iv = this.sync;
        boolean $i$f$invoke = false;
        this_$iv.lock();
        try {
            boolean bl = false;
            if (!this.getActual()) {
                long actualGeneration = this.generation.get();
                this.cachedValue = this.builder.invoke();
                this.timer.reset();
                this.committed.set(actualGeneration);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unLock();
        }
        Object object = this.cachedValue;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedValue");
            object = Unit.INSTANCE;
        }
        return object;
    }

    public final boolean getActual() {
        return this.timer.getTime().compareTo(this.timeout) <= 0 && this.generation.get() <= this.committed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long invalidate(@NotNull Function0<Unit> code) {
        Intrinsics.checkNotNullParameter(code, (String)"code");
        Sync this_$iv = this.sync;
        boolean $i$f$invoke = false;
        this_$iv.lock();
        try {
            boolean bl = false;
            code.invoke();
            long l = this.generation.incrementAndGet();
            return l;
        }
        finally {
            this_$iv.unLock();
        }
    }

    public static /* synthetic */ long invalidate$default(Cache cache, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = Cache::invalidate$lambda$1;
        }
        return cache.invalidate((Function0<Unit>)function0);
    }

    public final void waitForActual() {
        while (!this.getActual()) {
            Thread.sleep(10L);
        }
    }

    public final void waitForGeneration(long generation) {
        while (this.committed.get() < generation) {
            Thread.sleep(10L);
        }
    }

    private static final Unit invalidate$lambda$1() {
        return Unit.INSTANCE;
    }
}

