/*
 * Decompiled with CFR 0.152.
 */
package k.ofl.parse;

import java.util.ListIterator;
import k.common.StringsKt;
import k.ofl.OFLError;
import k.ofl.OflItem;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010*\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001fJ\u0006\u0010 \u001a\u00020!J\r\u0010\"\u001a\u00020!H\u0000\u00a2\u0006\u0002\b#J\b\u0010$\u001a\u00020!H\u0016J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0012J\u001b\u0010(\u001a\u00020!*\u00020\u00182\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120)H\u0086\u0004R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lk/ofl/parse/ParseItem;", "", "it", "", "", "<init>", "(Ljava/util/ListIterator;)V", "getIt$k_lib_common", "()Ljava/util/ListIterator;", "item", "Lk/ofl/OflItem;", "getItem", "()Lk/ofl/OflItem;", "nonPrintChars", "Lkotlin/ranges/CharRange;", "getNonPrintChars$k_lib_common", "()Lkotlin/ranges/CharRange;", "str", "", "getStr$k_lib_common", "()Ljava/lang/String;", "setStr$k_lib_common", "(Ljava/lang/String;)V", "strComplete", "", "getStrComplete$k_lib_common", "()Z", "setStrComplete$k_lib_common", "(Z)V", "parseStr", "strChar", "parseStr$k_lib_common", "parseSingleComment", "", "parseComment", "parseComment$k_lib_common", "parse", "error", "", "text", "orOflThrow", "Lkotlin/Function0;", "k-lib-common"})
public class ParseItem {
    @NotNull
    private final ListIterator<Character> it;
    @NotNull
    private final OflItem item;
    @NotNull
    private final CharRange nonPrintChars;
    @NotNull
    private String str;
    private boolean strComplete;

    public ParseItem(@NotNull ListIterator<Character> it) {
        Intrinsics.checkNotNullParameter(it, (String)"it");
        this.it = it;
        this.item = new OflItem();
        this.nonPrintChars = new CharRange('\u0000', ' ');
        this.str = "";
    }

    @NotNull
    public final ListIterator<Character> getIt$k_lib_common() {
        return this.it;
    }

    @NotNull
    public OflItem getItem() {
        return this.item;
    }

    @NotNull
    public final CharRange getNonPrintChars$k_lib_common() {
        return this.nonPrintChars;
    }

    @NotNull
    public final String getStr$k_lib_common() {
        return this.str;
    }

    public final void setStr$k_lib_common(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.str = string;
    }

    public final boolean getStrComplete$k_lib_common() {
        return this.strComplete;
    }

    public final void setStrComplete$k_lib_common(boolean bl) {
        this.strComplete = bl;
    }

    @NotNull
    public final String parseStr$k_lib_common(char strChar) {
        while (this.it.hasNext()) {
            char c = this.it.next().charValue();
            if (c == strChar) {
                return this.str;
            }
            this.str = this.str + c;
        }
        this.error("Unclosed string");
        throw new KotlinNothingValueException();
    }

    public final void parseSingleComment() {
        char c;
        while (this.it.hasNext() && (c = this.it.next().charValue()) != '\n' && c != '\r') {
        }
    }

    public final void parseComment$k_lib_common() {
        boolean isFirstChar = true;
        while (this.it.hasNext()) {
            if (this.it.next().charValue() == '#') {
                if (isFirstChar) {
                    this.parseSingleComment();
                }
                return;
            }
            isFirstChar = false;
        }
        this.error("Comment not closed");
        throw new KotlinNothingValueException();
    }

    public void parse() {
    }

    @NotNull
    public final Void error(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        throw new OFLError("[" + StringsKt.default(this.getItem().getPath(), "Root") + "] " + text);
    }

    public final void orOflThrow(boolean $this$orOflThrow, @NotNull Function0<String> text) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        if (!$this$orOflThrow) {
            this.error((String)text.invoke());
            throw new KotlinNothingValueException();
        }
    }
}

