/*
 * Decompiled with CFR 0.152.
 */
package k.serializing.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import k.common.CheckError;
import k.serializing.json.JsonArray;
import k.serializing.json.JsonContainer;
import k.serializing.json.JsonNode;
import k.serializing.json.JsonObject;
import k.serializing.json.JsonProperty;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0003H\u0002J\b\u0010\u0018\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lk/serializing/json/ResistantJson;", "", "text", "", "<init>", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "cursor", "", "start", "root", "Lk/serializing/json/JsonContainer;", "getRoot", "()Lk/serializing/json/JsonContainer;", "parse", "parseArray", "Lk/serializing/json/JsonArray;", "name", "parseObject", "Lk/serializing/json/JsonObject;", "parseNode", "Lk/serializing/json/JsonNode;", "parseString", "parseValue", "k-lib-common"})
@SourceDebugExtension(value={"SMAP\nResistantJson.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResistantJson.kt\nk/serializing/json/ResistantJson\n+ 2 OrThrow.kt\nk/common/OrThrowKt\n*L\n1#1,155:1\n8#2,7:156\n*S KotlinDebug\n*F\n+ 1 ResistantJson.kt\nk/serializing/json/ResistantJson\n*L\n41#1:156,7\n*E\n"})
public final class ResistantJson {
    @NotNull
    private final String text;
    private int cursor;
    private int start;
    @NotNull
    private final JsonContainer root;

    public ResistantJson(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        this.root = this.parse();
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final JsonContainer getRoot() {
        return this.root;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonContainer parse() {
        JsonContainer jsonContainer;
        void $this$orThrow$iv;
        char c;
        List items = new ArrayList();
        List properties = new ArrayList();
        while (this.cursor < this.text.length()) {
            int n;
            c = this.text.charAt(this.cursor);
            if (c == '[') {
                ((Collection)items).add(this.parseArray(""));
                continue;
            }
            if (c == '{') {
                ((Collection)items).add(this.parseObject(""));
                continue;
            }
            if (c == ' ' || c == '\t' || c == ',') {
                n = this.cursor;
                this.cursor = n + 1;
                continue;
            }
            if (CharsKt.isWhitespace((char)c)) {
                n = this.cursor;
                this.cursor = n + 1;
                continue;
            }
            ((Collection)properties).add(this.parseNode());
        }
        c = items.isEmpty() || properties.isEmpty() ? (char)'\u0001' : '\u0000';
        String error$iv = "Objects and properties in root detected";
        boolean $i$f$orThrow = false;
        void $this$orThrow$iv$iv = $this$orThrow$iv;
        boolean $i$f$orThrow2 = false;
        if ($this$orThrow$iv$iv == false) {
            boolean bl = false;
            throw (Throwable)new CheckError(error$iv);
        }
        if (properties.isEmpty()) {
            switch (items.size()) {
                case 0: {
                    jsonContainer = new JsonObject("", CollectionsKt.listOf((Object)new JsonProperty("Content", this.text)));
                    break;
                }
                case 1: {
                    jsonContainer = (JsonContainer)CollectionsKt.first((List)items);
                    break;
                }
                default: {
                    jsonContainer = new JsonArray("", items);
                    break;
                }
            }
        } else {
            jsonContainer = new JsonObject("", properties);
        }
        return jsonContainer;
    }

    private final JsonArray parseArray(String name) {
        int n = this.cursor;
        this.cursor = n + 1;
        List items = new ArrayList();
        while (this.cursor < this.text.length()) {
            int n2;
            char c = this.text.charAt(this.cursor);
            if (c == ']' || c == '}') {
                n2 = this.cursor;
                this.cursor = n2 + 1;
                break;
            }
            if (c == '{') {
                ((Collection)items).add(this.parseObject(""));
                continue;
            }
            if (c == '[') {
                ((Collection)items).add(this.parseArray(""));
                continue;
            }
            if (c == ' ' || c == '\t' || c == ',') {
                n2 = this.cursor;
                this.cursor = n2 + 1;
                continue;
            }
            if (c == '\"') {
                ((Collection)items).add(new JsonNode(this.parseString()));
                continue;
            }
            if (CharsKt.isWhitespace((char)c)) {
                n2 = this.cursor;
                this.cursor = n2 + 1;
                continue;
            }
            ((Collection)items).add(new JsonNode(this.parseValue()));
        }
        return new JsonArray(name, items);
    }

    private final JsonObject parseObject(String name) {
        int n = this.cursor;
        this.cursor = n + 1;
        List children = new ArrayList();
        while (this.cursor < this.text.length()) {
            int n2;
            char c = this.text.charAt(this.cursor);
            if (c == '}') {
                n2 = this.cursor;
                this.cursor = n2 + 1;
                break;
            }
            if (c == ' ' || c == '\t' || c == ',') {
                n2 = this.cursor;
                this.cursor = n2 + 1;
                continue;
            }
            if (CharsKt.isWhitespace((char)c)) {
                n2 = this.cursor;
                this.cursor = n2 + 1;
                continue;
            }
            ((Collection)children).add(this.parseNode());
        }
        return new JsonObject(name, children);
    }

    private final JsonNode parseNode() {
        String name;
        String string = name = this.text.charAt(this.cursor) == '\"' ? this.parseString() : this.parseValue();
        while (this.cursor < this.text.length()) {
            int n;
            char c = this.text.charAt(this.cursor);
            if (c == '{') {
                return this.parseObject(name);
            }
            if (c == '[') {
                return this.parseArray(name);
            }
            if (c == ' ' || c == '\t' || c == ':') {
                n = this.cursor;
                this.cursor = n + 1;
                continue;
            }
            if (c == '\"') {
                return new JsonProperty(name, this.parseString());
            }
            if (CharsKt.isWhitespace((char)c)) {
                n = this.cursor;
                this.cursor = n + 1;
                continue;
            }
            return new JsonProperty(name, this.parseValue());
        }
        return new JsonProperty(name, "");
    }

    private final String parseString() {
        ++this.cursor;
        this.start = this.cursor;
        while (this.cursor < this.text.length() && (this.text.charAt(this.cursor) != '\"' || this.text.charAt(this.cursor - 1) == '\\')) {
            int n = this.cursor;
            this.cursor = n + 1;
        }
        String string = this.text;
        int n = this.start;
        int n2 = this.cursor;
        this.cursor = n2 + 1;
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    private final String parseValue() {
        char c;
        this.start = this.cursor;
        while (this.cursor < this.text.length() && !StringsKt.contains$default((CharSequence)"}],: \t\"", (char)(c = this.text.charAt(this.cursor)), (boolean)false, (int)2, null) && !CharsKt.isWhitespace((char)c)) {
            int n = this.cursor;
            this.cursor = n + 1;
        }
        String string = this.text.substring(this.start, this.cursor);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }
}

