/*
 * Decompiled with CFR 0.152.
 */
package k.stream;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import k.common.NumbersKt;
import k.stream.StreamStorage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0019H\u0002Jz\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2`\u0010\u001d\u001a\\\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(\"\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(#\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b($\u0012\u0004\u0012\u00020\u000b0\u001eH\u0002R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0005R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lk/stream/MemoryStorage;", "Lk/stream/StreamStorage;", "size", "", "<init>", "(J)V", "value", "getSize", "()J", "setSize", "read", "", "buf", "Ljava/nio/ByteBuffer;", "position", "write", "flush", "close", "connected", "", "getConnected", "()Z", "chunks", "", "chunkNumber", "", "chunkPosition", "number", "proceedChunks", "chunkCode", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "chunk", "bufPos", "chunkPos", "chunkSize", "k-lib-common"})
public final class MemoryStorage
implements StreamStorage {
    private long size;
    @NotNull
    private final List<ByteBuffer> chunks;

    public MemoryStorage(long size) {
        this.size = size;
        this.chunks = new ArrayList();
    }

    public /* synthetic */ MemoryStorage(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        this(l);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void setSize(long value) {
        int chunkCount = this.chunkNumber(value) + 1;
        while (((Collection)this.chunks).size() < chunkCount) {
            ((Collection)this.chunks).add(ByteBuffer.allocate(1024));
        }
        while (((Collection)this.chunks).size() > chunkCount) {
            this.chunks.removeLast();
        }
        this.size = value;
    }

    @Override
    public void read(@NotNull ByteBuffer buf, long position) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.proceedChunks(position, buf, (Function4<? super ByteBuffer, ? super Integer, ? super Integer, ? super Integer, Unit>)((Function4)(arg_0, arg_1, arg_2, arg_3) -> MemoryStorage.read$lambda$0(buf, arg_0, arg_1, arg_2, arg_3)));
    }

    @Override
    public void write(@NotNull ByteBuffer buf, long position) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.proceedChunks(position, buf, (Function4<? super ByteBuffer, ? super Integer, ? super Integer, ? super Integer, Unit>)((Function4)(arg_0, arg_1, arg_2, arg_3) -> MemoryStorage.write$lambda$1(buf, arg_0, arg_1, arg_2, arg_3)));
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean getConnected() {
        return true;
    }

    private final int chunkNumber(long position) {
        return NumbersKt.getInt(position / (long)1024);
    }

    private final long chunkPosition(int number) {
        return (long)number * (long)1024;
    }

    private final void proceedChunks(long position, ByteBuffer buf, Function4<? super ByteBuffer, ? super Integer, ? super Integer, ? super Integer, Unit> chunkCode) {
        int piece;
        long curPosition = position;
        int remainReadSize = buf.limit() - buf.position();
        int chunkNumber = this.chunkNumber(curPosition);
        int startPos = NumbersKt.getInt(curPosition - this.chunkPosition(chunkNumber));
        do {
            ByteBuffer curChunk = this.chunks.get(chunkNumber);
            piece = Integer.min(remainReadSize, NumbersKt.getInt(this.chunkPosition(++chunkNumber) - curPosition));
            curChunk.position(startPos);
            chunkCode.invoke((Object)curChunk, (Object)(buf.limit() - remainReadSize), (Object)startPos, (Object)piece);
            startPos = 0;
            curPosition += (long)piece;
        } while ((remainReadSize -= piece) > 0);
    }

    private static final Unit read$lambda$0(ByteBuffer $buf, ByteBuffer chunk, int bufPos, int chunkPos, int chunkSize) {
        Intrinsics.checkNotNullParameter((Object)$buf, (String)"$buf");
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        $buf.put(bufPos, chunk, chunkPos, chunkSize);
        return Unit.INSTANCE;
    }

    private static final Unit write$lambda$1(ByteBuffer $buf, ByteBuffer chunk, int bufPos, int chunkPos, int chunkSize) {
        Intrinsics.checkNotNullParameter((Object)$buf, (String)"$buf");
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        chunk.put(chunkPos, $buf, bufPos, chunkSize);
        return Unit.INSTANCE;
    }

    public MemoryStorage() {
        this(0L, 1, null);
    }
}

