/*
 * Decompiled with CFR 0.152.
 */
package k.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import k.common.CheckError;
import k.common.OtherKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aF\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u000326\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00010\u0005\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\n\u0010\r\u001a\u00020\f*\u00020\f\u001a1\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00032!\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00010\u0010\u001a4\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122!\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u0002H\u00120\u0010\u00a2\u0006\u0002\u0010\u0014\"\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u0003*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u001b\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\"\u001b\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u0019*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001b\"\u001b\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0019*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001b\u00a8\u0006!"}, d2={"forEachFile", "", "dir", "", "code", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "path", "Ljava/io/InputStream;", "stream", "forceDir", "Ljava/io/File;", "force", "useFile", "fileName", "Lkotlin/Function1;", "useTmpFile", "T", "file", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "text", "getText", "(Ljava/io/File;)Ljava/lang/String;", "dirs", "", "getDirs", "(Ljava/io/File;)Ljava/util/List;", "files", "getFiles", "fileTree", "Ljava/nio/file/Path;", "getFileTree", "k-lib-common"})
@SourceDebugExtension(value={"SMAP\nFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Files.kt\nk/common/FilesKt\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 3 OrThrow.kt\nk/common/OrThrowKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,71:1\n32#2,2:72\n8#3,7:74\n3829#4:81\n4344#4,2:82\n3829#4:84\n4344#4,2:85\n*S KotlinDebug\n*F\n+ 1 Files.kt\nk/common/FilesKt\n*L\n8#1:72,2\n20#1:74,7\n57#1:81\n57#1:82,2\n63#1:84\n63#1:85,2\n*E\n"})
public final class FilesKt {
    public static final void forEachFile(@NotNull String dir, @NotNull Function2<? super String, ? super InputStream, Unit> code) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        Iterator iterator = Files.walk(Path.of(dir, new String[0]), new FileVisitOption[0]).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            Path it = (Path)element$iv;
            boolean bl = false;
            String name = ((Object)it).toString();
            code.invoke((Object)name, (Object)new FileInputStream(new File(name)));
        }
    }

    @NotNull
    public static final File forceDir(@NotNull String dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return FilesKt.force(new File(dir));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File force(@NotNull File $this$force) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$force, (String)"<this>");
        File it = file = $this$force.getCanonicalFile().getAbsoluteFile();
        boolean bl = false;
        if (!it.exists()) {
            void $this$orThrow$iv;
            boolean bl2 = it.mkdirs();
            String error$iv = "Failed to create " + it;
            boolean $i$f$orThrow = false;
            void $this$orThrow$iv$iv = $this$orThrow$iv;
            boolean $i$f$orThrow2 = false;
            if ($this$orThrow$iv$iv == false) {
                boolean bl3 = false;
                throw (Throwable)new CheckError(error$iv);
            }
        }
        File file2 = file;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"also(...)");
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void useFile(@NotNull String fileName, @NotNull Function1<? super String, Unit> code) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        try {
            code.invoke((Object)fileName);
        }
        finally {
            if (new File(fileName).exists()) {
                new File(fileName).delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T useTmpFile(@NotNull Function1<? super File, ? extends T> code) {
        Intrinsics.checkNotNullParameter(code, (String)"code");
        File file = new File(System.getProperty("java.io.tmpdir") + "/" + OtherKt.getID());
        try {
            file.createNewFile();
            Object object = code.invoke((Object)file);
            return (T)object;
        }
        finally {
            if (file.exists()) {
                file.delete();
            }
        }
    }

    @Nullable
    public static final String getText(@NotNull File $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"<this>");
        return $this$text.exists() ? kotlin.io.FilesKt.readText$default((File)$this$text, null, (int)1, null) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> getDirs(@NotNull File $this$dirs) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$dirs, (String)"<this>");
        if ($this$dirs.exists() && $this$dirs.isDirectory()) {
            List list2;
            File[] fileArray = $this$dirs.listFiles();
            if (fileArray != null) {
                void $this$filterTo$iv$iv;
                File[] $this$filter$iv = fileArray;
                boolean $i$f$filter = false;
                File[] fileArray2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl = false;
                    if (!it.isDirectory()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> getFiles(@NotNull File $this$files) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$files, (String)"<this>");
        if ($this$files.exists() && $this$files.isDirectory()) {
            List list2;
            File[] fileArray = $this$files.listFiles();
            if (fileArray != null) {
                void $this$filterTo$iv$iv;
                File[] $this$filter$iv = fileArray;
                boolean $i$f$filter = false;
                File[] fileArray2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl = false;
                    if (!it.isFile()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final List<Path> getFileTree(@NotNull File $this$fileTree) {
        List<Object> list;
        Intrinsics.checkNotNullParameter((Object)$this$fileTree, (String)"<this>");
        if ($this$fileTree.exists()) {
            List<Object> list2 = Files.walk($this$fileTree.toPath(), new FileVisitOption[0]).filter(arg_0 -> FilesKt._get_fileTree_$lambda$5(FilesKt::_get_fileTree_$lambda$4, arg_0)).toList();
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"toList(...)");
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final boolean _get_fileTree_$lambda$4(Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final boolean _get_fileTree_$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

