/*
 * Decompiled with CFR 0.152.
 */
package k.common;

import java.util.concurrent.CopyOnWriteArrayList;
import k.common.CheckError;
import k.common.Duration;
import k.common.DurationKt;
import k.common.Error;
import k.common.MessagesKt;
import k.common.MsgType;
import k.common.OrThrowKt;
import k.common.StrKt;
import k.common.StringsKt;
import k.common.Timer;
import kotlin.Metadata;
import kotlin.UninitializedPropertyAccessException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a(\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a3\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\t0\u0006\u00a2\u0006\u0002\u0010\n\u001a\u001e\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a2\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u00012\b\b\u0002\u0010\u0012\u001a\u00020\u00012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001aE\u0010\u0013\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0014\u001a\u00020\r2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00012\b\b\u0002\u0010\u0018\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\t0\u0006\u00a2\u0006\u0002\u0010\u0019\u001aK\u0010\u0013\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0010\b\u0002\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u001d2\b\b\u0002\u0010\u0018\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\t0\u0006\u00a2\u0006\u0002\u0010\u001e\u001a'\u0010\u001f\u001a\u0004\u0018\u0001H\t\"\u0004\b\u0000\u0010\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\t0\u0006H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 \u001aH\u0010\u001f\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2!\u0010!\u001a\u001d\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u0002H\t0\"2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\t0\u0006H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'\u001a\u0014\u0010(\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006)"}, d2={"softTryProc", "", "timeout", "Lk/common/Duration;", "delay", "proc", "Lkotlin/Function0;", "", "tryProc", "T", "(Lk/common/Duration;Lk/common/Duration;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "perfCheck", "label", "", "code", "perfTest", "limit", "warming", "showResults", "stage", "message", "msgType", "Lk/common/MsgType;", "logError", "errorText", "(Ljava/lang/String;Lk/common/MsgType;ZLjava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "log", "Lorg/slf4j/Logger;", "errors", "Ljava/util/concurrent/CopyOnWriteArrayList;", "(Ljava/lang/String;Lorg/slf4j/Logger;Ljava/util/concurrent/CopyOnWriteArrayList;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "mute", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "default", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "e", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "softCatch", "k-lib-common"})
@SourceDebugExtension(value={"SMAP\nWrapProcs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WrapProcs.kt\nk/common/WrapProcsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 OrThrow.kt\nk/common/OrThrowKt\n*L\n1#1,192:1\n1#2:193\n8#3,7:194\n22#3:201\n*S KotlinDebug\n*F\n+ 1 WrapProcs.kt\nk/common/WrapProcsKt\n*L\n105#1:194,7\n136#1:201\n*E\n"})
public final class WrapProcsKt {
    public static final boolean softTryProc(@NotNull Duration timeout, @NotNull Duration delay, @NotNull Function0<Unit> proc) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        Intrinsics.checkNotNullParameter(proc, (String)"proc");
        Timer timer = new Timer();
        while (true) {
            try {
                proc.invoke();
                return true;
            }
            catch (Throwable throwable) {
                if (timer.getTime().compareTo(timeout) > 0) {
                    return false;
                }
                delay.sleep();
                continue;
            }
            break;
        }
    }

    public static /* synthetic */ boolean softTryProc$default(Duration duration, Duration duration2, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            duration = DurationKt.getSec(5);
        }
        if ((n & 2) != 0) {
            duration2 = DurationKt.getSec(1);
        }
        return WrapProcsKt.softTryProc(duration, duration2, (Function0<Unit>)function0);
    }

    public static final <T> T tryProc(@NotNull Duration timeout, @NotNull Duration delay, @NotNull Function0<? extends T> proc) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        Intrinsics.checkNotNullParameter(proc, (String)"proc");
        Timer timer = new Timer();
        while (true) {
            try {
                return (T)proc.invoke();
            }
            catch (Throwable e) {
                if (timer.getTime().compareTo(timeout) > 0) {
                    throw e;
                }
                delay.sleep();
                continue;
            }
            break;
        }
    }

    public static /* synthetic */ Object tryProc$default(Duration duration, Duration duration2, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            duration = DurationKt.getSec(5);
        }
        if ((n & 2) != 0) {
            duration2 = DurationKt.getSec(1);
        }
        return WrapProcsKt.tryProc(duration, duration2, function0);
    }

    @NotNull
    public static final Duration perfCheck(@NotNull String label, @NotNull Function0<Unit> code) {
        Duration duration;
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        Duration it = duration = new Duration((Function0<Unit>)((Function0)() -> WrapProcsKt.perfCheck$lambda$0(code)));
        boolean bl = false;
        System.out.println((Object)(label + it.getStr()));
        return duration;
    }

    public static /* synthetic */ Duration perfCheck$default(String string, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return WrapProcsKt.perfCheck(string, (Function0<Unit>)function0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Duration perfTest(@NotNull Duration limit, boolean warming, boolean showResults, @NotNull Function0<Unit> code) {
        void $this$orThrow$iv;
        Intrinsics.checkNotNullParameter((Object)limit, (String)"limit");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        Duration fastMS = DurationKt.getMs(5);
        if (warming || !limit.isZero() && limit.compareTo(fastMS) < 0) {
            WrapProcsKt.perfTest$default(null, false, false, code, 3, null);
        }
        int minCount = 10;
        int fastCount = 100;
        Duration totalDuration = Duration.Companion.getZERO();
        Duration maxDuration = Duration.Companion.getNEGATIVE_INFINITE();
        Duration minDuration = Duration.Companion.getINFINITE();
        int seriesCount = 0;
        int totalCount = 0;
        while (seriesCount < minCount) {
            Duration duration = new Duration((Function0<Unit>)((Function0)() -> WrapProcsKt.perfTest$lambda$2(code)));
            ++totalCount;
            ++seriesCount;
            if (duration.compareTo(fastMS) < 0) {
                minCount = fastCount;
            }
            if (duration.compareTo(maxDuration) > 0) {
                maxDuration = duration;
                seriesCount = 0;
            }
            if (duration.compareTo(minDuration) < 0) {
                minDuration = duration;
                seriesCount = 0;
            }
            totalDuration = totalDuration.plus(duration);
        }
        Duration avgDuration = totalDuration.div(totalCount);
        if (showResults) {
            MessagesKt.msgInt$default("\n==== Performance test ====\n\n", MsgType.Text, null, 4, null);
            if (!warming && avgDuration.compareTo(fastMS) < 0) {
                MessagesKt.msgInt$default("The result is unstable because the average duration is less than " + fastMS.getStr() + "\n", MsgType.Warning, null, 4, null);
            }
            MessagesKt.msgInt$default("Avg: " + avgDuration.getStr(), MsgType.Info, null, 4, null);
            if (limit.compareTo(0L) > 0 && limit.compareTo(avgDuration) >= 0) {
                MessagesKt.msgInt$default(" [" + limit + " passed]", MsgType.Ok, null, 4, null);
            }
            MessagesKt.msgInt$default("\nMin: " + minDuration + "\n", MsgType.Ok, null, 4, null);
            MessagesKt.msgInt$default("Max: " + maxDuration + "\n\n", MsgType.Error, null, 4, null);
            MessagesKt.msgInt$default("Count : " + totalCount + "\n", MsgType.Text, null, 4, null);
            MessagesKt.msgInt$default("\n==========================\n\n", MsgType.Text, null, 4, null);
        }
        boolean bl = limit.isZero() || limit.compareTo(avgDuration) >= 0;
        String error$iv = "Time limit (" + limit + ") exceeded with a value of " + avgDuration + "!";
        boolean $i$f$orThrow = false;
        void $this$orThrow$iv$iv = $this$orThrow$iv;
        boolean $i$f$orThrow2 = false;
        if ($this$orThrow$iv$iv == false) {
            boolean bl2 = false;
            throw (Throwable)new CheckError(error$iv);
        }
        return avgDuration;
    }

    public static /* synthetic */ Duration perfTest$default(Duration duration, boolean bl, boolean bl2, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            duration = Duration.Companion.getZERO();
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return WrapProcsKt.perfTest(duration, bl, bl2, (Function0<Unit>)function0);
    }

    public static final <T> T stage(@NotNull String message, @NotNull MsgType msgType, boolean logError, @NotNull String errorText, @NotNull Function0<? extends T> code) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)msgType), (String)"msgType");
        Intrinsics.checkNotNullParameter((Object)errorText, (String)"errorText");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        try {
            Object object;
            Timer timer = new Timer();
            MessagesKt.msg(StringsKt.getN(message + "... "), msgType);
            Object it = object = code.invoke();
            boolean bl = false;
            MessagesKt.msg(StringsKt.getN("Done (" + timer.getTime() + ")"), MsgType.InfoOk);
            return (T)object;
        }
        catch (Throwable e) {
            Object object;
            String text = StringsKt.prefix(StringsKt.getDot(StringsKt.getUnTitle(message)), "Failed to ");
            CharSequence charSequence = errorText;
            if (kotlin.text.StringsKt.isBlank((CharSequence)charSequence)) {
                boolean bl = false;
                object = "\n" + text + "\n" + ((Object)kotlin.text.StringsKt.trim((CharSequence)StrKt.getStr(e))).toString();
            } else {
                object = charSequence;
            }
            String msg = kotlin.text.StringsKt.replace$default((String)StringsKt.getN((String)object), (String)"\n", (String)"\n    ", (boolean)false, (int)4, null);
            if (logError) {
                MessagesKt.msg(msg, MsgType.Error);
                e.printStackTrace();
            }
            throw new Error(msg);
        }
    }

    public static /* synthetic */ Object stage$default(String string, MsgType msgType, boolean bl, String string2, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            msgType = MsgType.Info;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            string2 = "";
        }
        return WrapProcsKt.stage(string, msgType, bl, string2, function0);
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T stage(@NotNull String message, @NotNull Logger log, @Nullable CopyOnWriteArrayList<String> errors, @NotNull String errorText, @NotNull Function0<? extends T> code) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)errorText, (String)"errorText");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        try {
            void $this$orThrow$iv;
            String string = message;
            Object error$iv = "Empty stage message";
            boolean $i$f$orThrow = false;
            OrThrowKt.orThrow($this$orThrow$iv, (Function0<? extends Throwable>)((Function0)new Function0<Throwable>((String)error$iv){
                final /* synthetic */ String $error;
                {
                    this.$error = $error;
                }

                public final Throwable invoke() {
                    return new CheckError(this.$error);
                }
            }));
            Timer timer = new Timer();
            log.info(message + "... ");
            Object it = error$iv = code.invoke();
            boolean bl = false;
            log.info(message + ": Done (" + timer.getTime() + ")");
            return (T)error$iv;
        }
        catch (Throwable e) {
            String msg;
            block2: {
                String text = StringsKt.prefix(StringsKt.getDot(StringsKt.getUnTitle(message)), "Failed to ");
                msg = kotlin.text.StringsKt.replace$default((String)StringsKt.getN(StringsKt.default(errorText, (Function0<String>)((Function0)() -> WrapProcsKt.stage$lambda$6(text, e)))), (String)"\n", (String)"\n    ", (boolean)false, (int)4, null);
                log.error(msg);
                CopyOnWriteArrayList<String> copyOnWriteArrayList = errors;
                if (copyOnWriteArrayList == null) break block2;
                copyOnWriteArrayList.add(msg);
            }
            throw new Error(msg);
        }
    }

    public static /* synthetic */ Object stage$default(String string, Logger logger, CopyOnWriteArrayList copyOnWriteArrayList, String string2, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            copyOnWriteArrayList = null;
        }
        if ((n & 8) != 0) {
            string2 = "";
        }
        return WrapProcsKt.stage(string, logger, copyOnWriteArrayList, string2, function0);
    }

    @Nullable
    public static final <T> T mute(@NotNull Function0<? extends T> code) {
        Object object;
        Intrinsics.checkNotNullParameter(code, (String)"code");
        boolean $i$f$mute = false;
        try {
            object = code.invoke();
        }
        catch (Throwable e) {
            Throwable throwable = e;
            if (throwable instanceof OutOfMemoryError) {
                throw e;
            }
            if (throwable instanceof UninitializedPropertyAccessException) {
                throw e;
            }
            object = null;
        }
        return (T)object;
    }

    public static final <T> T mute(@NotNull Function1<? super Throwable, ? extends T> function1, @NotNull Function0<? extends T> code) {
        Object object;
        Intrinsics.checkNotNullParameter(function1, (String)"default");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        boolean $i$f$mute = false;
        try {
            object = code.invoke();
        }
        catch (Throwable e) {
            Throwable throwable = e;
            if (throwable instanceof OutOfMemoryError) {
                throw e;
            }
            if (throwable instanceof UninitializedPropertyAccessException) {
                throw e;
            }
            object = function1.invoke((Object)e);
        }
        return (T)object;
    }

    @NotNull
    public static final String softCatch(@NotNull Function0<Unit> code) {
        String string;
        Intrinsics.checkNotNullParameter(code, (String)"code");
        try {
            code.invoke();
            string = "";
        }
        catch (Throwable e) {
            string = ((Object)kotlin.text.StringsKt.trim((CharSequence)StrKt.getStr(e))).toString();
        }
        return string;
    }

    private static final Unit perfCheck$lambda$0(Function0 $code) {
        Intrinsics.checkNotNullParameter((Object)$code, (String)"$code");
        $code.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit perfTest$lambda$2(Function0 $code) {
        Intrinsics.checkNotNullParameter((Object)$code, (String)"$code");
        $code.invoke();
        return Unit.INSTANCE;
    }

    private static final String stage$lambda$6(String $text, Throwable $e) {
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        return "\n" + $text + "\n" + ((Object)kotlin.text.StringsKt.trim((CharSequence)StrKt.getStr($e))).toString();
    }
}

