package k.common

import java.net.URI
import java.nio.file.*
import kotlin.io.path.*

object JustObject

fun isResourceExists(name : String) =
    JustObject.javaClass.classLoader.getResource(name) != null

fun resource(name : String) =
    JustObject.javaClass.classLoader.getResourceAsStream(name) orThrow """Resources "$name" not found"""

class Resources(dir : String) : RootPath(JustObject.javaClass.classLoader
                                             .getResource(dir mustBeSpecified "Resources directory")
                                             ?.toURI()
                                                 mustBeFound """Resources directory "$dir" was not found""")

open class RootPath(private var uri : URI) {
    private val rootPathStr : String
    private val basePath =
        if (uri.toPath().extension == "jar") {
            rootPathStr = "jar:$uri!/"
            uri = URI(rootPathStr)
            FileSystems.newFileSystem(uri, emptyMap<String, Any>()).getPath("/")
        }
        else {
            rootPathStr = "$uri"
            uri.toPath()
        }

    val names
        get() =
            Files.walk(basePath)
                .filter { it.isRegularFile() }
                .map { it.toUri().str.replace("///", "/") }
                .map { it.urlDecode }
                .map { (it - rootPathStr.urlDecode).trim('/') }
                .toList()
                .toTypedArray()

    val fullNames
        get() = names.map { basePath.str.replace('\\', '/') + "/" + it }.toTypedArray()
}