package k.console.table

import k.common.*

enum class Align(private val fmt : (value : String, width : Int) -> String)
{
    Left({ v, w -> v + ' '.pad(w) }),
    Center({ v, w -> ' '.pad(w / 2) + v + ' '.pad(w - w / 2)}),
    Right({ v, w -> ' '.pad(w) + v });

    operator fun invoke(value : String, width : Int) =
        fmt(value, width - value.length)
}