package k.ofl.parse

import k.common.default
import k.ofl.*

const val commentChar = '#'

open class ParseItem(internal val it : ListIterator<Char>)
{
    open val item : OflItem = OflItem()
    internal val nonPrintChars = 0.toChar()..' '
    internal var str = ""
    internal var strComplete = false

    internal fun parseStr(strChar : Char) : String
    {
        while (it.hasNext())
            when (val c = it.next())
            {
                strChar -> return str
                else    -> str += c
            }

        error("Unclosed string")
    }

    fun parseSingleComment()
    {
        while (it.hasNext())
        {
            when (it.next())
            {
                '\n', '\r' -> break
            }
        }
    }

    internal fun parseComment()
    {
        var isFirstChar = true

        while (it.hasNext())
        {
            when (it.next())
            {
                commentChar ->
                {
                    if (isFirstChar) parseSingleComment()

                    return
                }

                else        -> isFirstChar = false
            }
        }

        error("Comment not closed")
    }

    open fun parse()
    {
    }

    fun error(text : String) : Nothing =
        throw OFLError("[${item.path default "Root"}] $text")

    infix fun Boolean.orOflThrow(text : () -> String)
    {
        if (!this)
            error(text())
    }
}