package k.ofl.parse

import k.common.*
import k.ofl.*

open class ParseObject(it : ListIterator<Char>) : ParseItem(it)
{
    override val item = OflObject()

    fun add(parser : ParseItem)
    {
        parser.item.name = str

        item.put(parser.item)

        parser.parse()

        strComplete = false
        str = ""
    }

    open fun parseEx(char : Char) : Boolean
    {
        when (char)
        {
            '='              -> add(ParseProperty(it))
            in nonPrintChars -> strComplete != str.isEmpty()
            item.finishChar  ->
            {
                item.parent.isNotNull orOflThrow { "'${char}' has no pair" }

                return true
            }

            else             ->
            {
                (char !in "})]") orOflThrow { "'${char}' has no pair" }

                str += char
            }
        }

        return false
    }

    override fun parse()
    {
        while (it.hasNext())
        {
            when (val char = it.next())
            {
                '{'         -> add(ParseObject(it))
                '['         -> add(ParseArray(it))
                '('         -> add(ParseCall(it))
                '"', '\''   -> parseStr(char)
                commentChar -> parseSingleComment()
                else        -> if (parseEx(char)) return
            }
        }

        item.parent.isNull orOflThrow { "Object not closed" }
    }
}