package k.ofl.parse

import k.ofl.OflProperty

class ParseProperty(it : ListIterator<Char>) : ParseItem(it)
{
    override val item = OflProperty()

    override fun parse()
    {
        while (it.hasNext())
        {
            when (val c = it.next())
            {
                '"', '\'', '`'               ->
                {
                    parseStr(c)

                    break
                }

                '\n', '\r'                   ->
                    break

                commentChar                  -> parseSingleComment()
                '}', ']', ')', '[', '{', '(' ->
                {
                    it.previous()

                    break
                }

                in nonPrintChars             -> if (str > "") break
                else                         -> str += c
            }
        }

        item.value = str
    }
}