package k.common

import java.text.DecimalFormat

val Long.sizeStr: String
    get() = sizeStr(this)

val Int.amount: String
    get() = amountStr(this.toLong())

val Int.sizeStr: String
    get() = sizeStr(this.toLong())

class Part(val size: Long, val suffix: String)

fun sizeStr(size: Long) =
    sizeStr(size,
            arrayOf(Part(PB, "PB"),
                    Part(TB, "TB"),
                    Part(GB, "GB"),
                    Part(MB, "MB"),
                    Part(KB, "KB"),
                    Part(1, "b")),
            "0 b")

fun amountStr(size: Long) =
    sizeStr(size,
            arrayOf(Part(Billion, "B"),
                    Part(Million, "M"),
                    Part(Thousand, "K"),
                    Part(1, "")),
            "0")

fun sizeStr(size: Long, parts: Array<Part>, zeroStr: String): String
{
    var v = size

    for (p in parts)
    {
        val part = v.toDouble() / p.size

        if (part.toLong().isZero)
            continue

        v -= part.toLong() * size

        return DecimalFormat(if (part < 10) "#.#" else "#").format(part) + (" " + p.suffix).trimEnd()
    }

    return zeroStr
}