package k.common

import k.parallels.Sync
import java.util.concurrent.atomic.AtomicLong

const val step = 10L

class Cache<T : Any>(private val timeout : Duration = Duration.INFINITE, private val builder : () -> T) {
    private val timer = Timer()
    private val generation = AtomicLong(0)
    private val committed = AtomicLong(-1)
    private val sync = Sync()

    private lateinit var cachedValue : T

    val value : T
        get() {
            sync {
                if (!actual) {
                    val actualGeneration = generation.get()

                    cachedValue = builder()

                    timer.reset()
                    committed.set(actualGeneration)
                }
            }

            return cachedValue
        }

    val actual
        get() = timer.time <= timeout && generation.get() <= committed.get()

    fun invalidate(code : () -> Unit = {}) : Long {
        sync {
            code()

            return generation.incrementAndGet()
        }
    }

    fun waitForActual() {
        while (!actual)
            Thread.sleep(step)
    }

    fun waitForGeneration(generation : Long) {
        while (committed.get() < generation)
            Thread.sleep(step)
    }
}