package k.common

import java.util.concurrent.atomic.AtomicReference
import kotlin.concurrent.thread
import kotlin.properties.ReadWriteProperty
import kotlin.reflect.KProperty

/**
 * Async lazy variable initializer
 */
fun <T> future(desc : String = Thread.currentThread().stackTrace[2].let { "Init val in ${it.fileName?.str}:${it.lineNumber}" },
               initializer : () -> T) =
    lazy { initializer() }.also { thread(name = desc) { stage(desc) { it.value } } }

class AtomicProperty<T>(value : T) : ReadWriteProperty<Any?, T> {
    private val value = AtomicReference(value)

    override fun getValue(thisRef : Any?, property : KProperty<*>) : T =
        value.get()

    override fun setValue(thisRef : Any?, property : KProperty<*>, value : T) {
        this.value.set(value)
    }
}