package k.common

inline fun <K, V> MutableMap<K, V>.ensure(key : K, factory : () -> V) =
    this[key]
    ?: factory().also {
        this[key] = it
    }

inline infix fun <reified K, reified V> Map<K, V>?.ensure(value : Pair<K, V>) =
    if (this == null)
        mapOf(value)
    else if (this.keys.contains(value.first))
        this
    else
        this + value