package k.common

/**
 * Must be not null
 * Must be not blank
 * Must be not false
 * Must be not empty
 */
@Suppress("NOTHING_TO_INLINE")
inline infix fun String?.mustBeSpecified(id : String) : String =
    if (isNullOrBlank())
        throw NotSpecifiedError(id)
    else
        this

@Suppress("NOTHING_TO_INLINE")
inline infix fun Boolean?.mustBeSpecified(id : String) : Boolean =
    orThrow { NotSpecifiedError(id) }

@Suppress("NOTHING_TO_INLINE")
inline infix fun <T> List<T>?.mustBeSpecified(id : String) : List<T> =
    if (!isNullOrEmpty())
        this
    else
        throw NotSpecifiedError(id)

@Suppress("NOTHING_TO_INLINE")
inline infix fun <K, V> Map<K, V>?.mustBeSpecified(id : String) : Map<K, V> =
    if (!isNullOrEmpty())
        this
    else
        throw NotSpecifiedError(id)