package k.common

import java.util.HashMap

class NamedPool<T>(val initializer: () -> T)
{
    private val items = HashMap<String, T>()
    operator fun get(name: String): T
    {
        synchronized(items) {
            if (!items.containsKey(name))
                items[name] = initializer()

            return items[name]!!
        }
    }

    fun forEach(code: (name: String, value: T) -> Unit) =
        items.forEach { code(it.key, it.value) }
}