package k.common

interface Transactional
{
    fun startTransaction()
    fun commit()
    fun rollback()

    infix fun <R> transaction(code : () -> R) =
        try
        {
            startTransaction()

            code()

            commit()
        }
        catch (e : Throwable)
        {
            rollback()

            throw e
        }
}