package k.ofl

import k.common.str

class OflArray : OflObject()
{
    override fun find(name : String, recursive : OflRecursive) : OflItem? =
        null

    override val startChar = '['
    override val finishChar = ']'
    override val clone
        get() : OflItem = doClone(OflArray())

    fun add(value : Any) =
        add(OflProperty("", value.str))

    override fun add(item : OflItem) : OflItem
    {
        val clone = if (item.parent == null)
            item
        else
            item.clone

        clone.parent = this

        children.add(clone)

        return item
    }

    override fun add(name : String, value : String) : OflProperty
    {
        val property = OflProperty(name, value)

        property.parent = this

        children.add(property)

        return property
    }

    override fun put(item : OflItem)
    {
        item.parent = this

        children.add(item)
    }

    operator fun plusAssign(value : Any)
    {
        add(value)
    }

    val asObject : OflObject
        get() = if (count == 1)
            this[0]
        else
            throw OFLError("No data available")
}