package k.parallels

class RoundPool<T>(override val count: Int, private val creator: () -> T) : Pool<T>
{
    private val items = mutableListOf<T>()

    private var i = count
    override val resource: T
        get()
        {
            synchronized(this) {
                i++

                if (i >= count)
                    i = 0

                if (i >= items.count())
                    items.add(creator())

                return items[i]
            }
        }

    override fun forEachResource(code: (item: T) -> Unit) =
        items.forEach(code)
}