package k.serializing.json

open class JsonNode(val name : String) {
    companion object {
        fun parse(text : String) =
            ResistantJson(text).root
    }

    override fun toString() =
        name

    open val key
        get() = name

    val String.quoted
        get() = "\"$this\""

    open fun toJson() =
        name.quoted
}