package k.serializing.json

import k.common.*

class JsonObject(name : String, items : List<JsonNode>) : JsonContainer(name, items) {
    operator fun get(name : String) =
        items.find { it.name same name }

    override fun toString() =
        (name merge " ") +
                if (items.isEmpty())
                    "$openObject$closeObject"
                else
                    "$openObject\n${items.joinToString("\n") { it.toString() }}\n$closeObject"

    override fun toJson() =
        "${if (name.isNotBlank()) "\"$name\" " else ""}$valueDivider $openObject\n${items.joinToString(divider.str) { it.toJson() }}\n$closeObject"
}