package k.stream

import k.common.orThrow
import java.nio.ByteBuffer
import java.nio.file.*
import java.nio.file.StandardOpenOption.*

class FileStorage(path: String, mode: Mode = Mode.Read) : StreamStorage
{
    enum class Mode(val options: Set<OpenOption>)
    {
        New(setOf(CREATE, WRITE, READ)),
        Temp(setOf(CREATE, DELETE_ON_CLOSE, WRITE, READ)),
        Read(setOf(READ)),
        Write(setOf(WRITE, READ));
    }

    private val file = Files.newByteChannel(Paths.get(path), mode.options)

    override var size: Long
        get() = file.size()
        set(_)
        {
        }

    override fun read(buf: ByteBuffer, position: Long)
    {
        (file.position(position).read(buf.position(0)) == buf.limit()) orThrow "Failed to read"
    }

    override fun write(buf: ByteBuffer, position: Long)
    {
        (file.position(position).write(buf.position(0)) == buf.limit()) orThrow "Failed to write"
    }

    override fun flush()
    {
        TODO("Not yet implemented")
    }

    override fun close()
    {
        // Nothing
    }

    override val connected
        get() = true
}