package k.common

import java.lang.reflect.Field
import kotlin.reflect.KClass

val <T : Any> (() -> T).className
    get() = this.str.split(".").last()

val <T : Any, P> ((P) -> T).className
    get() = this.str.split(".").last()

val <T : Any> KClass<T>.className : String
    get() = extractClassName(this.simpleName.orEmpty())

val Class<*>.className : String
    get() = extractClassName(this.simpleName)

val <T : Any> T.className : String
    get() = extractClassName(this.javaClass.simpleName)

fun extractClassName(fullClassName : String) =
    fullClassName
        .split(".")
        .last() - Unnamed - namePrefix_ - namePrefix

fun <T> Class<T>.create(args : Array<Any>) : T =
    (constructors.find { it.parameterCount == args.size } orThrow "$className: Invalid parameters list")
        .newInstance(*args)
        .cast()

operator fun <T> Class<T>.invoke(vararg args : Any) : T =
    (constructors.find { it.parameterCount == args.size } orThrow "$className: Invalid parameters list").newInstance(*args).cast()

fun <T : Any, R> T.notImplemented(method : String = "~") : R =
    TODO("$className.$method")

inline fun <reified T : Annotation> Field.annotation() : T? =
    this.getAnnotation(T::class.java)