package k.common

import java.io.File

/**
 * Must be not null
 * Must be not false
 * Must be existed
 */

@Suppress("NOTHING_TO_INLINE")
inline infix fun Boolean?.mustBeFound(id : String) : Boolean =
    orThrow { NotFoundError("${id.quoted} not found") }

@Suppress("NOTHING_TO_INLINE")
inline infix fun String?.mustBeFound(id : String) : String =
    orThrow { NotFoundError("${id.quoted} not found") }

@Suppress("NOTHING_TO_INLINE")
inline infix fun <T> T?.mustBeFound(id : String) : T =
    orThrow { NotFoundError("${id.quoted} not found") }

@Suppress("NOTHING_TO_INLINE")
inline infix fun File?.mustBeFound(message : String) =
    this?.exists() orThrow { NotFoundError(message) }
