package k.common

/**
 * Must be true
 */
@Suppress("NOTHING_TO_INLINE")
inline infix fun Boolean?.orThrow(error : String) : Boolean =
    orThrow { CheckError(error) }

inline infix fun Boolean?.orThrow(throwable : () -> Throwable) : Boolean =
    if (this == null || !this)
        throw throwable()
    else
        this

/**
 * Must be not null
 */

@Suppress("NOTHING_TO_INLINE")
inline infix fun <T> T?.orThrow(error : String) : T =
    orThrow { CheckError(error) }

fun <T> T?.orThrow(throwable : () -> Throwable) : T =
    this
    ?: throw throwable()