package k.parallels

class MultiStorage<T>(private val initializer: () -> T)
{
    private val threadValues = mutableMapOf<Thread, T>()

    val value: T
        get() = synchronized(this) {
            val thread = Thread.currentThread()

            threadValues[thread]
            ?: initializer().also { threadValues[thread] = it }
        }

    val values
        get() = threadValues.values.toList()
}