/*
 * Decompiled with CFR 0.152.
 */
package k.stream;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import k.common.NumbersKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001b\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0015\u0010\u0013\u001a\u00020\u0014*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\"\u0015\u0010\u0017\u001a\u00020\u0018*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\"\u0015\u0010\u001b\u001a\u00020\u001c*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\"\u001d\u0010\u001f\u001a\n !*\u0004\u0018\u00010 0 *\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\"\u0015\u0010$\u001a\u00020%*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\"\u0015\u0010(\u001a\u00020)*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\"\u001b\u0010,\u001a\b\u0012\u0004\u0012\u00020)0\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\b\"\u0015\u0010.\u001a\u00020/*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b0\u00101\"\u0015\u00102\u001a\u000203*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b4\u00105\"\u0015\u00106\u001a\u000207*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b8\u00109\"\u0015\u0010:\u001a\u00020 *\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b;\u0010#\"\u0015\u0010<\u001a\u00020%*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b=\u0010'\u00a8\u0006>"}, d2={"long", "", "Ljava/io/InputStream;", "getLong", "(Ljava/io/InputStream;)J", "longs", "", "getLongs", "(Ljava/io/InputStream;)Ljava/util/List;", "int", "", "getInt", "(Ljava/io/InputStream;)I", "ints", "getInts", "short", "", "getShort", "(Ljava/io/InputStream;)S", "dbl", "", "getDbl", "(Ljava/io/InputStream;)D", "byte", "", "getByte", "(Ljava/io/InputStream;)B", "bln", "", "getBln", "(Ljava/io/InputStream;)Z", "array", "", "kotlin.jvm.PlatformType", "getArray", "(Ljava/io/InputStream;)[B", "string", "", "getString", "(Ljava/io/InputStream;)Ljava/lang/String;", "uuid", "Ljava/util/UUID;", "getUuid", "(Ljava/io/InputStream;)Ljava/util/UUID;", "uuids", "getUuids", "time", "Ljava/util/Date;", "getTime", "(Ljava/io/InputStream;)Ljava/util/Date;", "unCompressed", "Ljava/util/zip/GZIPInputStream;", "getUnCompressed", "(Ljava/io/InputStream;)Ljava/util/zip/GZIPInputStream;", "compressedStream", "Ljava/io/PipedInputStream;", "getCompressedStream", "(Ljava/io/InputStream;)Ljava/io/PipedInputStream;", "compressed", "getCompressed", "text", "getText", "k-lib-common"})
public final class InputStreamExtensionsKt {
    public static final long getLong(@NotNull InputStream $this$long) {
        Intrinsics.checkNotNullParameter((Object)$this$long, (String)"<this>");
        return ByteBuffer.wrap($this$long.readNBytes(8)).getLong();
    }

    @NotNull
    public static final List<Long> getLongs(@NotNull InputStream $this$longs) {
        Intrinsics.checkNotNullParameter((Object)$this$longs, (String)"<this>");
        return NumbersKt.map(InputStreamExtensionsKt.getInt($this$longs), arg_0 -> InputStreamExtensionsKt._get_longs_$lambda$0($this$longs, arg_0));
    }

    public static final int getInt(@NotNull InputStream $this$int) {
        Intrinsics.checkNotNullParameter((Object)$this$int, (String)"<this>");
        return ByteBuffer.wrap($this$int.readNBytes(4)).getInt();
    }

    @NotNull
    public static final List<Integer> getInts(@NotNull InputStream $this$ints) {
        Intrinsics.checkNotNullParameter((Object)$this$ints, (String)"<this>");
        return NumbersKt.map(InputStreamExtensionsKt.getInt($this$ints), arg_0 -> InputStreamExtensionsKt._get_ints_$lambda$1($this$ints, arg_0));
    }

    public static final short getShort(@NotNull InputStream $this$short) {
        Intrinsics.checkNotNullParameter((Object)$this$short, (String)"<this>");
        return ByteBuffer.wrap($this$short.readNBytes(2)).getShort();
    }

    public static final double getDbl(@NotNull InputStream $this$dbl) {
        Intrinsics.checkNotNullParameter((Object)$this$dbl, (String)"<this>");
        return ByteBuffer.wrap($this$dbl.readNBytes(8)).getDouble();
    }

    public static final byte getByte(@NotNull InputStream $this$byte) {
        Intrinsics.checkNotNullParameter((Object)$this$byte, (String)"<this>");
        return $this$byte.readNBytes(1)[0];
    }

    public static final boolean getBln(@NotNull InputStream $this$bln) {
        Intrinsics.checkNotNullParameter((Object)$this$bln, (String)"<this>");
        return NumbersKt.getBln(InputStreamExtensionsKt.getByte($this$bln));
    }

    public static final byte[] getArray(@NotNull InputStream $this$array) {
        Intrinsics.checkNotNullParameter((Object)$this$array, (String)"<this>");
        return $this$array.readNBytes(InputStreamExtensionsKt.getInt($this$array));
    }

    @NotNull
    public static final String getString(@NotNull InputStream $this$string) {
        Intrinsics.checkNotNullParameter((Object)$this$string, (String)"<this>");
        byte[] byArray = $this$string.readNBytes(InputStreamExtensionsKt.getInt($this$string));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.UTF_8;
        return new String(byArray2, charset);
    }

    @NotNull
    public static final UUID getUuid(@NotNull InputStream $this$uuid) {
        Intrinsics.checkNotNullParameter((Object)$this$uuid, (String)"<this>");
        return new UUID(InputStreamExtensionsKt.getLong($this$uuid), InputStreamExtensionsKt.getLong($this$uuid));
    }

    @NotNull
    public static final List<UUID> getUuids(@NotNull InputStream $this$uuids) {
        Intrinsics.checkNotNullParameter((Object)$this$uuids, (String)"<this>");
        return NumbersKt.map(InputStreamExtensionsKt.getInt($this$uuids), arg_0 -> InputStreamExtensionsKt._get_uuids_$lambda$2($this$uuids, arg_0));
    }

    @NotNull
    public static final Date getTime(@NotNull InputStream $this$time) {
        Intrinsics.checkNotNullParameter((Object)$this$time, (String)"<this>");
        return new Date(InputStreamExtensionsKt.getLong($this$time));
    }

    @NotNull
    public static final GZIPInputStream getUnCompressed(@NotNull InputStream $this$unCompressed) {
        Intrinsics.checkNotNullParameter((Object)$this$unCompressed, (String)"<this>");
        InputStream it = $this$unCompressed;
        boolean bl = false;
        if ($this$unCompressed.markSupported()) {
            $this$unCompressed.reset();
        }
        return new GZIPInputStream($this$unCompressed);
    }

    @NotNull
    public static final PipedInputStream getCompressedStream(@NotNull InputStream $this$compressedStream) {
        PipedInputStream pipedInputStream;
        Intrinsics.checkNotNullParameter((Object)$this$compressedStream, (String)"<this>");
        PipedInputStream it = pipedInputStream = new PipedInputStream();
        boolean bl = false;
        if ($this$compressedStream.markSupported()) {
            $this$compressedStream.reset();
        }
        PipedOutputStream output = new PipedOutputStream(it);
        GZIPOutputStream zip = new GZIPOutputStream(output);
        Thread.startVirtualThread(() -> InputStreamExtensionsKt._get_compressedStream_$lambda$6$lambda$5(output, $this$compressedStream, zip));
        return pipedInputStream;
    }

    @NotNull
    public static final byte[] getCompressed(@NotNull InputStream $this$compressed) {
        Intrinsics.checkNotNullParameter((Object)$this$compressed, (String)"<this>");
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        GZIPOutputStream zip = new GZIPOutputStream(buf);
        zip.write($this$compressed.readAllBytes());
        zip.finish();
        byte[] byArray = buf.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    @NotNull
    public static final String getText(@NotNull InputStream $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"<this>");
        InputStream inputStream = $this$text;
        Charset charset = Charsets.UTF_8;
        return TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
    }

    private static final long _get_longs_$lambda$0(InputStream $this_longs, int it) {
        Intrinsics.checkNotNullParameter((Object)$this_longs, (String)"$this_longs");
        return InputStreamExtensionsKt.getLong($this_longs);
    }

    private static final int _get_ints_$lambda$1(InputStream $this_ints, int it) {
        Intrinsics.checkNotNullParameter((Object)$this_ints, (String)"$this_ints");
        return InputStreamExtensionsKt.getInt($this_ints);
    }

    private static final UUID _get_uuids_$lambda$2(InputStream $this_uuids, int it) {
        Intrinsics.checkNotNullParameter((Object)$this_uuids, (String)"$this_uuids");
        return InputStreamExtensionsKt.getUuid($this_uuids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void _get_compressedStream_$lambda$6$lambda$5(PipedOutputStream $output, InputStream $this_compressedStream, GZIPOutputStream $zip) {
        Intrinsics.checkNotNullParameter((Object)$output, (String)"$output");
        Intrinsics.checkNotNullParameter((Object)$this_compressedStream, (String)"$this_compressedStream");
        Intrinsics.checkNotNullParameter((Object)$zip, (String)"$zip");
        Closeable closeable = $output;
        Throwable throwable = null;
        try {
            PipedOutputStream it = (PipedOutputStream)closeable;
            boolean bl = false;
            ByteStreamsKt.copyTo$default((InputStream)$this_compressedStream, (OutputStream)$zip, (int)0, (int)2, null);
            $zip.finish();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

