package k.docker.engine

import k.common.ParamList
import k.docker.Docker
import k.docker.models.*

class ContainerController : ControllerEngine
{
    override fun create(service : Service) =
        Docker.createContainer(service, run = true)

    override fun update(instance : ServiceInstance, service : Service) : String
    {
        Docker.removeContainer(service.fullName)
        return create(service)
    }

    override fun remove(id : String)
    {
        Docker.removeContainer(id)
    }

    override fun scale(id : String, count : Int)
    {
        if (count == 0)
            Docker.stopContainer(id)
        else
            Docker.startContainer(id)
    }

    override fun restart(id : String)
    {
        Docker.restartContainer(id)
    }
}