package k.docker.engine

import k.common.ParamList
import k.docker.Docker
import k.docker.engine.ControllerEngine
import k.docker.models.*

class ServiceController : ControllerEngine
{
    override fun create(service : Service) =
        Docker.createService(service)

    override fun update(instance : ServiceInstance, service : Service) =
        Docker.updateService(instance, service)

    override fun remove(id : String)
    {
        Docker.removeService(id)
    }

    override fun scale(id : String, count : Int)
    {
        Docker.scaleService(id, count)
    }

    override fun restart(id : String)
    {
        Docker.restartService(id)
    }
}