package k.docker.engine

import k.common.ParamList
import k.docker.Docker
import k.docker.engine.ControllerEngine
import k.docker.models.*

class StackController : ControllerEngine
{
    override fun create(service : Service) : String =
        Docker.createStack(service)

    override fun update(instance : ServiceInstance, service : Service) : String =
        create(service)

    override fun remove(id : String)
    {
        Docker.removeService(id)
    }

    override fun scale(id : String, count : Int)
    {
        Docker.scaleService(id, count)
    }

    override fun restart(id : String)
    {
        Docker.restartService(id)
    }
}