package k.docker.models

import k.common.ParamList
import k.serializing.Format
import k.serializing.Optional
import java.util.*

data class ContainerParams(val Id: String,
                           val Name: String,
                           val HostConfig: HostCfg,
                           val Mounts: List<Mount>,
                           val Config: Cfg,
                           val RestartCount: Int,
                           @Format("ISO8601-OFFSET")
                           val Created: Date,
                           @Optional
                           val Image: String,
                           @Optional
                           val NetworkSettings: NetSettings,
                           val State: ContainerState) {
    class HostCfg(@Optional
                  val PortBindings: Map<String, String>)

    class Bind(val HostPort: String)
    class Mount(val Destination: String)

    class Cfg(@Optional
              val Labels: ParamList,
              @Optional
              val Env: List<String>)

    class ContainerState(val Status: String,
                         val ExitCode: Int,
                         @Format("ISO8601-OFFSET")
                         val StartedAt: Date,
                         @Format("ISO8601-OFFSET")
                         val FinishedAt: Date)

    class NetSettings(@Optional
                      val Networks: Map<String, NetDesc> = mapOf())

    class NetDesc
}